/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.ILogicalDeletePluginHook;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class EnumTypeStatusPlugin
extends BasePlugin
implements ILogicalDeletePluginHook {
    public static final String PRO_AUTO_SCAN = "autoScan";
    public static final String PRO_ENUM_COLUMNS = "enumColumns";
    public static final String REMARKS_PATTERN = ".*\\s*\\[\\s*(\\w+\\s*\\(\\s*[\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+\\s*\\)\\s*:\\s*[\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+\\s*\\,?\\s*)+\\s*\\]\\s*.*";
    public static final String NEED_PATTERN = "\\[\\s*((\\w+\\s*\\(\\s*[\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+\\s*\\)\\s*:\\s*[\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+\\s*\\,?\\s*)+)\\s*\\]";
    public static final String ITEM_PATTERN = "(\\w+)\\s*\\(\\s*([\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+)\\s*\\)\\s*:\\s*([\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+)";
    private Map<String, EnumInfo> enumColumns;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        block9: {
            block8: {
                String[] enumColumnsStrs;
                super.initialized(introspectedTable);
                this.enumColumns = new LinkedHashMap<String, EnumInfo>();
                String autoScan = this.getProperties().getProperty(PRO_AUTO_SCAN);
                if (!StringUtility.stringHasValue((String)autoScan) || StringUtility.isTrue((String)autoScan)) break block8;
                String enumColumns = this.getProperties().getProperty(PRO_ENUM_COLUMNS);
                String tableEnumColumns = introspectedTable.getTableConfigurationProperty(PRO_ENUM_COLUMNS);
                if (tableEnumColumns != null) {
                    enumColumns = enumColumns == null ? "" : enumColumns + ",";
                    enumColumns = enumColumns + introspectedTable.getTableConfigurationProperty(PRO_ENUM_COLUMNS);
                }
                if (!StringUtility.stringHasValue((String)enumColumns)) break block9;
                for (String enumColumnsStr : enumColumnsStrs = enumColumns.split(",")) {
                    IntrospectedColumn column = IntrospectedTableTools.safeGetColumn(introspectedTable, enumColumnsStr);
                    if (column == null) continue;
                    try {
                        EnumInfo enumInfo = new EnumInfo(column);
                        enumInfo.parseRemarks(column.getRemarks());
                        if (!enumInfo.hasItems()) continue;
                        this.enumColumns.put(column.getJavaProperty(), enumInfo);
                    }
                    catch (EnumInfo.CannotParseException e) {
                        this.warnings.add("itfsw:\u63d2\u4ef6" + EnumTypeStatusPlugin.class.getTypeName() + "\u6ca1\u6709\u627e\u5230column\u4e3a" + enumColumnsStr.trim() + "\u5bf9\u5e94\u683c\u5f0f\u7684\u6ce8\u91ca\u7684\u5b57\u6bb5\uff01");
                    }
                    catch (EnumInfo.NotSupportTypeException e) {
                        this.warnings.add("itfsw:\u63d2\u4ef6" + EnumTypeStatusPlugin.class.getTypeName() + "\u627e\u5230column\u4e3a" + enumColumnsStr.trim() + "\u5bf9\u5e94Java\u7c7b\u578b\u4e0d\u5728\u652f\u6301\u8303\u56f4\u5185\uff01");
                    }
                }
                break block9;
            }
            for (IntrospectedColumn column : introspectedTable.getAllColumns()) {
                try {
                    EnumInfo enumInfo = new EnumInfo(column);
                    enumInfo.parseRemarks(column.getRemarks());
                    if (!enumInfo.hasItems()) continue;
                    this.enumColumns.put(column.getJavaProperty(), enumInfo);
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateModelEnum(topLevelClass, introspectedTable);
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateModelEnum(topLevelClass, introspectedTable);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    @Override
    public boolean clientLogicalDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return true;
    }

    @Override
    public boolean clientLogicalDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return true;
    }

    @Override
    public boolean sqlMapLogicalDeleteByExampleElementGenerated(Document document, XmlElement element, IntrospectedColumn logicalDeleteColumn, String logicalDeleteValue, IntrospectedTable introspectedTable) {
        return true;
    }

    @Override
    public boolean sqlMapLogicalDeleteByPrimaryKeyElementGenerated(Document document, XmlElement element, IntrospectedColumn logicalDeleteColumn, String logicalDeleteValue, IntrospectedTable introspectedTable) {
        return true;
    }

    @Override
    public boolean logicalDeleteEnumGenerated(IntrospectedColumn logicalDeleteColumn) {
        return this.enumColumns.containsKey(logicalDeleteColumn.getJavaProperty());
    }

    private void generateModelEnum(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        for (Field field : topLevelClass.getFields()) {
            if (this.enumColumns.get(field.getName()) == null) continue;
            InnerEnum innerEnum = this.enumColumns.get(field.getName()).generateEnum(this.commentGenerator, introspectedTable);
            topLevelClass.addInnerEnum(innerEnum);
        }
    }

    public static class EnumInfo {
        private List<EnumItemInfo> items = new ArrayList<EnumItemInfo>();
        private IntrospectedColumn column;

        public EnumInfo(IntrospectedColumn column) throws NotSupportTypeException, CannotParseException {
            String javaType = column.getFullyQualifiedJavaType().getFullyQualifiedName();
            if (!(Short.class.getTypeName().equals(javaType) || Integer.class.getTypeName().equals(javaType) || Long.class.getTypeName().equals(javaType) || Boolean.class.getTypeName().equals(javaType) || Double.class.getTypeName().equals(javaType) || Float.class.getTypeName().equals(javaType) || BigDecimal.class.getTypeName().equals(javaType) || Byte.class.getTypeName().equals(javaType) || String.class.getTypeName().equals(javaType))) {
                throw new NotSupportTypeException();
            }
            this.column = column;
        }

        public void addItem(String name, String comment, String value) {
            this.items.add(new EnumItemInfo(this.column, name, comment, value));
        }

        public boolean hasItems() {
            return this.items.size() > 0;
        }

        public void parseRemarks(String remarks) throws CannotParseException {
            if (!StringUtility.stringHasValue((String)remarks) || !remarks.matches(EnumTypeStatusPlugin.REMARKS_PATTERN)) {
                throw new CannotParseException();
            }
            Pattern pattern = Pattern.compile(EnumTypeStatusPlugin.NEED_PATTERN);
            Matcher matcher = pattern.matcher(remarks);
            if (matcher.find() && matcher.groupCount() == 2) {
                String[] enumInfoStrs;
                String enumInfoStr = matcher.group(1);
                for (String enumInfoItemStr : enumInfoStrs = enumInfoStr.split(",")) {
                    pattern = Pattern.compile(EnumTypeStatusPlugin.ITEM_PATTERN);
                    matcher = pattern.matcher(enumInfoItemStr.trim());
                    if (!matcher.find() || matcher.groupCount() != 3) continue;
                    this.addItem(matcher.group(1), matcher.group(3), matcher.group(2));
                }
            }
        }

        public List<EnumItemInfo> getItems() {
            return this.items;
        }

        public InnerEnum generateEnum(CommentGenerator commentGenerator, IntrospectedTable introspectedTable) {
            String enumName = FormatTools.upFirstChar(this.column.getJavaProperty());
            InnerEnum innerEnum = new InnerEnum(new FullyQualifiedJavaType(enumName));
            commentGenerator.addEnumComment(innerEnum, introspectedTable);
            innerEnum.setVisibility(JavaVisibility.PUBLIC);
            innerEnum.setStatic(true);
            for (EnumItemInfo item : this.items) {
                innerEnum.addEnumConstant(item.getName() + "(" + item.getValue() + ", " + item.getComment() + ")");
            }
            Field fValue = new Field("value", this.column.getFullyQualifiedJavaType());
            fValue.setVisibility(JavaVisibility.PRIVATE);
            fValue.setFinal(true);
            commentGenerator.addFieldComment(fValue, introspectedTable);
            innerEnum.addField(fValue);
            Field fName = new Field("name", FullyQualifiedJavaType.getStringInstance());
            fName.setVisibility(JavaVisibility.PRIVATE);
            fName.setFinal(true);
            commentGenerator.addFieldComment(fName, introspectedTable);
            innerEnum.addField(fName);
            Method mInc = new Method(enumName);
            mInc.setConstructor(true);
            mInc.addBodyLine("this.value = value;");
            mInc.addBodyLine("this.name = name;");
            mInc.addParameter(new Parameter(fValue.getType(), "value"));
            mInc.addParameter(new Parameter(fName.getType(), "name"));
            commentGenerator.addGeneralMethodComment(mInc, introspectedTable);
            FormatTools.addMethodWithBestPosition(innerEnum, mInc);
            Method mValue = JavaElementGeneratorTools.generateGetterMethod(fValue);
            commentGenerator.addGeneralMethodComment(mValue, introspectedTable);
            FormatTools.addMethodWithBestPosition(innerEnum, mValue);
            Method mValue1 = JavaElementGeneratorTools.generateGetterMethod(fValue);
            mValue1.setName("value");
            commentGenerator.addGeneralMethodComment(mValue1, introspectedTable);
            FormatTools.addMethodWithBestPosition(innerEnum, mValue1);
            Method mName = JavaElementGeneratorTools.generateGetterMethod(fName);
            commentGenerator.addGeneralMethodComment(mName, introspectedTable);
            FormatTools.addMethodWithBestPosition(innerEnum, mName);
            return innerEnum;
        }

        public class EnumItemInfo {
            private IntrospectedColumn column;
            private String name;
            private String comment;
            private String value;

            public EnumItemInfo(IntrospectedColumn column, String name, String comment, String value) {
                this.column = column;
                this.name = name.trim();
                this.comment = comment.trim();
                this.value = value.trim();
            }

            public String getComment() {
                return "\"" + this.comment + "\"";
            }

            public String getName() {
                return this.name.toUpperCase();
            }

            public String getValue() {
                String javaType = this.column.getFullyQualifiedJavaType().getShortName();
                if ("NULL".equalsIgnoreCase(this.value)) {
                    return "null";
                }
                return "new " + javaType + "(\"" + this.value + "\")";
            }

            public String getOriginalValue() {
                return this.value;
            }
        }

        public class CannotParseException
        extends Exception {
        }

        public class NotSupportTypeException
        extends Exception {
        }
    }
}

