/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.Kv;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;

public class CardPayApi {
    private static String activateUrl = "https://api.weixin.qq.com/card/pay/activate?access_token=";
    private static String getPayPriceUrl = "https://api.weixin.qq.com/card/pay/getpayprice?access_token=";
    private static String getCoinsInfoUrl = "https://api.weixin.qq.com/card/pay/getcoinsinfo?access_token=";
    private static String confirmUrl = "https://api.weixin.qq.com/card/pay/confirm?access_token=";
    private static String rechargeUrl = "https://api.weixin.qq.com/card/pay/recharge?access_token=";
    private static String getOrderUrl = "https://api.weixin.qq.com/card/pay/getorder?access_token=";
    private static String getOrderListUrl = "https://api.weixin.qq.com/card/pay/getorderlist?access_token=";

    public static ApiResult activate() {
        String jsonResult = HttpUtils.get(activateUrl + AccessTokenApi.getAccessTokenStr());
        return new ApiResult(jsonResult);
    }

    public static ApiResult getPayPrice(String cardId, int quantity) {
        Kv data = Kv.by((Object)"card_id", (Object)cardId).set((Object)"quantity", (Object)quantity);
        String jsonResult = HttpUtils.post(getPayPriceUrl + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getCoinsInfo() {
        String jsonResult = HttpUtils.get(getCoinsInfoUrl + AccessTokenApi.getAccessTokenStr());
        return new ApiResult(jsonResult);
    }

    public static ApiResult confirm(String cardId, int quantity, String orderId) {
        Kv data = Kv.by((Object)"card_id", (Object)cardId).set((Object)"quantity", (Object)quantity).set((Object)"order_id", (Object)orderId);
        String jsonResult = HttpUtils.post(confirmUrl + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult recharge(int coinCount) {
        Kv data = Kv.by((Object)"coin_count", (Object)coinCount);
        String jsonResult = HttpUtils.post(rechargeUrl + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getOrder(String orderId) {
        Kv data = Kv.by((Object)"order_id", (Object)orderId);
        String jsonResult = HttpUtils.post(getOrderUrl + AccessTokenApi.getAccessTokenStr(), JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getOrderList(String jsonStr) {
        String jsonResult = HttpUtils.post(getOrderListUrl + AccessTokenApi.getAccessTokenStr(), jsonStr);
        return new ApiResult(jsonResult);
    }
}

