/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.rest;

import com.nepxion.discovery.console.rest.AbstractRestInvoker;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.client.RestTemplate;

public class SentinelClearRestInvoker
extends AbstractRestInvoker {
    private String type;

    public SentinelClearRestInvoker(List<ServiceInstance> serviceInstances, RestTemplate restTemplate, String type) {
        super(serviceInstances, restTemplate);
        this.type = type.trim();
    }

    @Override
    protected String getInfo() {
        return "Sentinel rules cleared";
    }

    @Override
    protected String getSuffixPath() {
        return this.getPrefixPath(this.type) + "/clear-" + this.type + "-rules";
    }

    @Override
    protected String doRest(String url) {
        return (String)this.restTemplate.postForEntity(url, null, String.class, new Object[0]).getBody();
    }

    @Override
    protected void checkPermission(ServiceInstance serviceInstance) throws Exception {
        this.checkConfigRestControlPermission(serviceInstance);
    }

    private String getPrefixPath(String type) {
        return StringUtils.equals((CharSequence)type, (CharSequence)"param-flow") ? "sentinel-param" : "sentinel-core";
    }
}

