/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.rest;

import com.nepxion.discovery.console.rest.AbstractRestInvoker;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SentinelUpdateRestInvoker
extends AbstractRestInvoker {
    private String type;
    private String rule;

    public SentinelUpdateRestInvoker(List<ServiceInstance> serviceInstances, RestTemplate restTemplate, String type, String rule) {
        super(serviceInstances, restTemplate);
        this.type = type.trim();
        this.rule = rule;
    }

    @Override
    protected String getInfo() {
        return "Sentinel rules updated";
    }

    @Override
    protected String getSuffixPath() {
        return this.getPrefixPath(this.type) + "/update-" + this.type + "-rules";
    }

    @Override
    protected String doRest(String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity entity = new HttpEntity((Object)this.rule, (MultiValueMap)headers);
        return (String)this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]).getBody();
    }

    @Override
    protected void checkPermission(ServiceInstance serviceInstance) throws Exception {
        this.checkConfigRestControlPermission(serviceInstance);
    }

    private String getPrefixPath(String type) {
        return StringUtils.equals((CharSequence)type, (CharSequence)"param-flow") ? "sentinel-param" : "sentinel-core";
    }
}

