/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.entity.StrategyConditionEntity;
import com.nepxion.discovery.common.entity.StrategyType;
import com.nepxion.discovery.plugin.strategy.condition.StrategyCondition;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/strategy"})
@Api(tags={"\u7b56\u7565\u63a5\u53e3"})
public class StrategyEndpoint {
    @Autowired
    private StrategyCondition strategyCondition;
    @Autowired
    private StrategyWrapper strategyWrapper;

    @RequestMapping(path={"/validate-expression"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6821\u9a8c\u7b56\u7565\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f", notes="", response=Boolean.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<Boolean> validateExpression(@RequestParam @ApiParam(value="\u6761\u4ef6\u8868\u8fbe\u5f0f\uff0c\u4f8b\u5982\uff1a#H['a'] == '1' && #H['b'] != '2'", required=true) String condition, @RequestParam(required=false, defaultValue="") @ApiParam(value="\u53d8\u91cf\u8d4b\u503c\uff0c\u4f8b\u5982\uff1aa=1;b=1\u3002\u5982\u679c\u591a\u4e2a\u7528\u201c;\u201d\u5206\u9694\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u7a7a\u683c\u3002\u5141\u8bb8\u4e3a\u7a7a", required=false, defaultValue="") String validation) {
        StrategyConditionEntity strategyConditionEntity = new StrategyConditionEntity();
        strategyConditionEntity.setConditionHeader(condition);
        Map<String, String> map = this.splitToMap(validation);
        boolean validated = this.strategyCondition.isTriggered(strategyConditionEntity, map);
        return ResponseEntity.ok().body((Object)validated);
    }

    @RequestMapping(path={"/validate-route"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6821\u9a8c\u7b56\u7565\u7684\u5168\u94fe\u8def\u8def\u7531", notes="", response=String.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<String> validateVersionRoute(@RequestParam @ApiParam(value="\u7b56\u7565\u7c7b\u578b\uff0c\u4f8b\u5982\uff1aversion, region, address, version-weight, region-weight", required=true) String strategyType, @RequestParam(required=false, defaultValue="") @ApiParam(value="\u53d8\u91cf\u8d4b\u503c\uff0c\u4f8b\u5982\uff1aa=1;b=1\u3002\u5982\u679c\u591a\u4e2a\u7528\u201c;\u201d\u5206\u9694\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u7a7a\u683c\u3002\u5141\u8bb8\u4e3a\u7a7a", required=false, defaultValue="") String validation) {
        StrategyType type = StrategyType.fromString((String)strategyType);
        Map<String, String> map = this.splitToMap(validation);
        String route = null;
        switch (type) {
            case VERSION: {
                route = this.strategyWrapper.getRouteVersion(map);
                break;
            }
            case REGION: {
                route = this.strategyWrapper.getRouteRegion(map);
                break;
            }
            case ADDRESS: {
                route = this.strategyWrapper.getRouteAddress(map);
                break;
            }
            case VERSION_WEIGHT: {
                route = this.strategyWrapper.getRouteVersionWeight(map);
                break;
            }
            case REGION_WEIGHT: {
                route = this.strategyWrapper.getRouteRegionWeight(map);
            }
        }
        return ResponseEntity.ok().body(route);
    }

    private Map<String, String> splitToMap(String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)value)) {
            String[] separateArray;
            for (String separateValue : separateArray = StringUtils.split((String)value, (String)";")) {
                String[] equalsArray = StringUtils.split((String)separateValue, (String)"=");
                map.put(equalsArray[0].trim(), equalsArray[1].trim());
            }
        }
        return map;
    }
}

