/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class ReplayDataSourceConnectionFactoryAdapter
extends OracleDataSourceConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(ReplayDataSourceConnectionFactoryAdapter.class.getCanonicalName());

    public ReplayDataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        super(dataSource);
    }

    public void initializeUrlFromConnectionFactory() {
        Class<?> dsClass = this.m_dataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
            Method m = cls.getMethod("getURL", new Class[0]);
            this.m_url = (String)m.invoke((Object)this.m_dataSource, new Object[0]);
            logger.finest("initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exc) {
            logger.throwing(this.getClass().getName(), "initializeUrlFromConnectionFactory: ", exc);
        }
    }

    public void setUrl(String url) {
        Class<?> dsClass = this.m_dataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.replay.OracleDataSourceImpl", true, dsClass.getClassLoader());
            Method m = cls.getMethod("setURL", String.class);
            m.invoke((Object)this.m_dataSource, url);
            logger.log(Level.FINEST, "setUrl({0}) succeeded", url);
        }
        catch (Exception exc) {
            logger.throwing(this.getClass().getName(), "setUrl: ", exc);
        }
    }
}

