package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link CatalogDeregistration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogDeregistration.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "CatalogDeregistration"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCatalogDeregistration
    extends CatalogDeregistration {
  private final @Nullable String datacenter;
  private final String node;
  private final @Nullable String checkId;
  private final @Nullable String serviceId;
  private final @Nullable WriteRequest writeRequest;

  private ImmutableCatalogDeregistration(
      @Nullable String datacenter,
      String node,
      @Nullable String checkId,
      @Nullable String serviceId,
      @Nullable WriteRequest writeRequest) {
    this.datacenter = datacenter;
    this.node = node;
    this.checkId = checkId;
    this.serviceId = serviceId;
    this.writeRequest = writeRequest;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public Optional<String> datacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public String node() {
    return node;
  }

  /**
   * @return The value of the {@code checkId} attribute
   */
  @JsonProperty(value = "CheckID")
  @Override
  public Optional<String> checkId() {
    return Optional.ofNullable(checkId);
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty(value = "ServiceID")
  @Override
  public Optional<String> serviceId() {
    return Optional.ofNullable(serviceId);
  }

  /**
   * @return The value of the {@code writeRequest} attribute
   */
  @JsonProperty(value = "WriteRequest")
  @Override
  public Optional<WriteRequest> writeRequest() {
    return Optional.ofNullable(writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogDeregistration#datacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withDatacenter(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableCatalogDeregistration(newValue, this.node, this.checkId, this.serviceId, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogDeregistration#datacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableCatalogDeregistration(value, this.node, this.checkId, this.serviceId, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogDeregistration#node() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogDeregistration withNode(String value) {
    if (this.node.equals(value)) return this;
    return new ImmutableCatalogDeregistration(
        this.datacenter,
        Preconditions.checkNotNull(value, "node"),
        this.checkId,
        this.serviceId,
        this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogDeregistration#checkId() checkId} attribute.
   * @param value The value for checkId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withCheckId(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "checkId");
    if (Objects.equals(this.checkId, newValue)) return this;
    return new ImmutableCatalogDeregistration(this.datacenter, this.node, newValue, this.serviceId, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogDeregistration#checkId() checkId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for checkId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withCheckId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.checkId, value)) return this;
    return new ImmutableCatalogDeregistration(this.datacenter, this.node, value, this.serviceId, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogDeregistration#serviceId() serviceId} attribute.
   * @param value The value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withServiceId(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "serviceId");
    if (Objects.equals(this.serviceId, newValue)) return this;
    return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, newValue, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogDeregistration#serviceId() serviceId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withServiceId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceId, value)) return this;
    return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, value, this.writeRequest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogDeregistration#writeRequest() writeRequest} attribute.
   * @param value The value for writeRequest
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withWriteRequest(WriteRequest value) {
    @Nullable WriteRequest newValue = Preconditions.checkNotNull(value, "writeRequest");
    if (this.writeRequest == newValue) return this;
    return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogDeregistration#writeRequest() writeRequest} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for writeRequest
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogDeregistration withWriteRequest(Optional<WriteRequest> optional) {
    @Nullable WriteRequest value = optional.orElse(null);
    if (this.writeRequest == value) return this;
    return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogDeregistration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogDeregistration
        && equalTo((ImmutableCatalogDeregistration) another);
  }

  private boolean equalTo(ImmutableCatalogDeregistration another) {
    return Objects.equals(datacenter, another.datacenter)
        && node.equals(another.node)
        && Objects.equals(checkId, another.checkId)
        && Objects.equals(serviceId, another.serviceId)
        && Objects.equals(writeRequest, another.writeRequest);
  }

  /**
   * Computes a hash code from attributes: {@code datacenter}, {@code node}, {@code checkId}, {@code serviceId}, {@code writeRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + com.google.common.base.Objects.hashCode(datacenter);
    h = h * 17 + node.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(checkId);
    h = h * 17 + com.google.common.base.Objects.hashCode(serviceId);
    h = h * 17 + com.google.common.base.Objects.hashCode(writeRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogDeregistration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogDeregistration")
        .omitNullValues()
        .add("datacenter", datacenter)
        .add("node", node)
        .add("checkId", checkId)
        .add("serviceId", serviceId)
        .add("writeRequest", writeRequest)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends CatalogDeregistration {
    Optional<String> datacenter = Optional.empty();
    @Nullable String node;
    Optional<String> checkId = Optional.empty();
    Optional<String> serviceId = Optional.empty();
    Optional<WriteRequest> writeRequest = Optional.empty();
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(Optional<String> datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty(value = "CheckID")
    public void setCheckId(Optional<String> checkId) {
      this.checkId = checkId;
    }
    @JsonProperty(value = "ServiceID")
    public void setServiceId(Optional<String> serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty(value = "WriteRequest")
    public void setWriteRequest(Optional<WriteRequest> writeRequest) {
      this.writeRequest = writeRequest;
    }
    @Override
    public Optional<String> datacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String node() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> checkId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> serviceId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<WriteRequest> writeRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableCatalogDeregistration fromJson(Json json) {
    ImmutableCatalogDeregistration.Builder builder = ImmutableCatalogDeregistration.builder();
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.checkId != null) {
      builder.checkId(json.checkId);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.writeRequest != null) {
      builder.writeRequest(json.writeRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CatalogDeregistration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogDeregistration instance
   */
  public static ImmutableCatalogDeregistration copyOf(CatalogDeregistration instance) {
    if (instance instanceof ImmutableCatalogDeregistration) {
      return (ImmutableCatalogDeregistration) instance;
    }
    return ImmutableCatalogDeregistration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogDeregistration ImmutableCatalogDeregistration}.
   * @return A new ImmutableCatalogDeregistration builder
   */
  public static ImmutableCatalogDeregistration.Builder builder() {
    return new ImmutableCatalogDeregistration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogDeregistration ImmutableCatalogDeregistration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private long initBits = 0x1;

    private @Nullable String datacenter;
    private @Nullable String node;
    private @Nullable String checkId;
    private @Nullable String serviceId;
    private @Nullable WriteRequest writeRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogDeregistration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CatalogDeregistration instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<String> datacenterOptional = instance.datacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      node(instance.node());
      Optional<String> checkIdOptional = instance.checkId();
      if (checkIdOptional.isPresent()) {
        checkId(checkIdOptional);
      }
      Optional<String> serviceIdOptional = instance.serviceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      Optional<WriteRequest> writeRequestOptional = instance.writeRequest();
      if (writeRequestOptional.isPresent()) {
        writeRequest(writeRequestOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#datacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#datacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogDeregistration#node() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#checkId() checkId} to checkId.
     * @param checkId The value for checkId
     * @return {@code this} builder for chained invocation
     */
    public final Builder checkId(String checkId) {
      this.checkId = Preconditions.checkNotNull(checkId, "checkId");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#checkId() checkId} to checkId.
     * @param checkId The value for checkId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder checkId(Optional<String> checkId) {
      this.checkId = checkId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#serviceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#serviceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = serviceId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#writeRequest() writeRequest} to writeRequest.
     * @param writeRequest The value for writeRequest
     * @return {@code this} builder for chained invocation
     */
    public final Builder writeRequest(WriteRequest writeRequest) {
      this.writeRequest = Preconditions.checkNotNull(writeRequest, "writeRequest");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogDeregistration#writeRequest() writeRequest} to writeRequest.
     * @param writeRequest The value for writeRequest
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder writeRequest(Optional<WriteRequest> writeRequest) {
      this.writeRequest = writeRequest.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogDeregistration ImmutableCatalogDeregistration}.
     * @return An immutable instance of CatalogDeregistration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogDeregistration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalogDeregistration(datacenter, node, checkId, serviceId, writeRequest);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      return "Cannot build CatalogDeregistration, some of required attributes are not set " + attributes;
    }
  }
}
