package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link CatalogService}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCatalogService.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "CatalogService"})
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableCatalogService extends CatalogService {
  private final String node;
  private final String address;
  private final @Nullable String datacenter;
  private final String serviceName;
  private final String serviceId;
  private final String serviceAddress;
  private final @Nullable Boolean serviceEnableTagOverride;
  private final int servicePort;
  private final ImmutableList<String> serviceTags;
  private final @Nullable Map<String, String> serviceMeta;
  private final @Nullable ServiceWeights serviceWeights;
  private final @Nullable Map<String, String> nodeMeta;

  private ImmutableCatalogService(
      String node,
      String address,
      @Nullable String datacenter,
      String serviceName,
      String serviceId,
      String serviceAddress,
      @Nullable Boolean serviceEnableTagOverride,
      int servicePort,
      ImmutableList<String> serviceTags,
      @Nullable Map<String, String> serviceMeta,
      @Nullable ServiceWeights serviceWeights,
      @Nullable Map<String, String> nodeMeta) {
    this.node = node;
    this.address = address;
    this.datacenter = datacenter;
    this.serviceName = serviceName;
    this.serviceId = serviceId;
    this.serviceAddress = serviceAddress;
    this.serviceEnableTagOverride = serviceEnableTagOverride;
    this.servicePort = servicePort;
    this.serviceTags = serviceTags;
    this.serviceMeta = serviceMeta;
    this.serviceWeights = serviceWeights;
    this.nodeMeta = nodeMeta;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code address} attribute
   */
  @JsonProperty(value = "Address")
  @Override
  public String getAddress() {
    return address;
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @JsonProperty(value = "Datacenter")
  @Override
  public Optional<String> getDatacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code serviceName} attribute
   */
  @JsonProperty(value = "ServiceName")
  @Override
  public String getServiceName() {
    return serviceName;
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty(value = "ServiceID")
  @Override
  public String getServiceId() {
    return serviceId;
  }

  /**
   * @return The value of the {@code serviceAddress} attribute
   */
  @JsonProperty(value = "ServiceAddress")
  @Override
  public String getServiceAddress() {
    return serviceAddress;
  }

  /**
   * @return The value of the {@code serviceEnableTagOverride} attribute
   */
  @JsonProperty(value = "ServiceEnableTagOverride")
  @Override
  public Optional<Boolean> getServiceEnableTagOverride() {
    return Optional.ofNullable(serviceEnableTagOverride);
  }

  /**
   * @return The value of the {@code servicePort} attribute
   */
  @JsonProperty(value = "ServicePort")
  @Override
  public int getServicePort() {
    return servicePort;
  }

  /**
   * @return The value of the {@code serviceTags} attribute
   */
  @JsonProperty(value = "ServiceTags")
  @Override
  public ImmutableList<String> getServiceTags() {
    return serviceTags;
  }

  /**
   * @return The value of the {@code serviceMeta} attribute
   */
  @JsonProperty(value = "ServiceMeta")
  @Override
  public Optional<Map<String, String>> getServiceMeta() {
    return Optional.ofNullable(serviceMeta);
  }

  /**
   * @return The value of the {@code serviceWeights} attribute
   */
  @JsonProperty(value = "ServiceWeights")
  @Override
  public Optional<ServiceWeights> getServiceWeights() {
    return Optional.ofNullable(serviceWeights);
  }

  /**
   * @return The value of the {@code nodeMeta} attribute
   */
  @JsonProperty(value = "NodeMeta")
  @Override
  public Optional<Map<String, String>> getNodeMeta() {
    return Optional.ofNullable(nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withNode(String value) {
    if (this.node.equals(value)) return this;
    return new ImmutableCatalogService(
        Preconditions.checkNotNull(value, "node"),
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getAddress() address} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for address
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withAddress(String value) {
    if (this.address.equals(value)) return this;
    return new ImmutableCatalogService(
        this.node,
        Preconditions.checkNotNull(value, "address"),
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withDatacenter(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        newValue,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getDatacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        value,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServiceName() serviceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceName(String value) {
    if (this.serviceName.equals(value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        Preconditions.checkNotNull(value, "serviceName"),
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServiceId() serviceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceId(String value) {
    if (this.serviceId.equals(value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        Preconditions.checkNotNull(value, "serviceId"),
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServiceAddress() serviceAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceAddress
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServiceAddress(String value) {
    if (this.serviceAddress.equals(value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        Preconditions.checkNotNull(value, "serviceAddress"),
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} attribute.
   * @param value The value for serviceEnableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceEnableTagOverride(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.serviceEnableTagOverride, newValue)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        newValue,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceEnableTagOverride
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceEnableTagOverride(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.serviceEnableTagOverride, value)) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        value,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CatalogService#getServicePort() servicePort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for servicePort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCatalogService withServicePort(int value) {
    if (this.servicePort == value) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        value,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CatalogService#getServiceTags() serviceTags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceTags(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        newValue,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CatalogService#getServiceTags() serviceTags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of serviceTags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
    if (this.serviceTags == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        newValue,
        this.serviceMeta,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getServiceMeta() serviceMeta} attribute.
   * @param value The value for serviceMeta
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceMeta(Map<String, String> value) {
    @Nullable Map<String, String> newValue = Preconditions.checkNotNull(value, "serviceMeta");
    if (this.serviceMeta == newValue) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        newValue,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getServiceMeta() serviceMeta} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceMeta
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceMeta(Optional<Map<String, String>> optional) {
    @Nullable Map<String, String> value = optional.orElse(null);
    if (this.serviceMeta == value) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        value,
        this.serviceWeights,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getServiceWeights() serviceWeights} attribute.
   * @param value The value for serviceWeights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceWeights(ServiceWeights value) {
    @Nullable ServiceWeights newValue = Preconditions.checkNotNull(value, "serviceWeights");
    if (this.serviceWeights == newValue) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        newValue,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getServiceWeights() serviceWeights} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceWeights
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withServiceWeights(Optional<ServiceWeights> optional) {
    @Nullable ServiceWeights value = optional.orElse(null);
    if (this.serviceWeights == value) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        value,
        this.nodeMeta);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CatalogService#getNodeMeta() nodeMeta} attribute.
   * @param value The value for nodeMeta
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withNodeMeta(Map<String, String> value) {
    @Nullable Map<String, String> newValue = Preconditions.checkNotNull(value, "nodeMeta");
    if (this.nodeMeta == newValue) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CatalogService#getNodeMeta() nodeMeta} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nodeMeta
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCatalogService withNodeMeta(Optional<Map<String, String>> optional) {
    @Nullable Map<String, String> value = optional.orElse(null);
    if (this.nodeMeta == value) return this;
    return new ImmutableCatalogService(
        this.node,
        this.address,
        this.datacenter,
        this.serviceName,
        this.serviceId,
        this.serviceAddress,
        this.serviceEnableTagOverride,
        this.servicePort,
        this.serviceTags,
        this.serviceMeta,
        this.serviceWeights,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCatalogService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCatalogService
        && equalTo((ImmutableCatalogService) another);
  }

  private boolean equalTo(ImmutableCatalogService another) {
    return node.equals(another.node)
        && address.equals(another.address)
        && Objects.equals(datacenter, another.datacenter)
        && serviceName.equals(another.serviceName)
        && serviceId.equals(another.serviceId)
        && serviceAddress.equals(another.serviceAddress)
        && Objects.equals(serviceEnableTagOverride, another.serviceEnableTagOverride)
        && servicePort == another.servicePort
        && serviceTags.equals(another.serviceTags)
        && Objects.equals(serviceMeta, another.serviceMeta)
        && Objects.equals(serviceWeights, another.serviceWeights)
        && Objects.equals(nodeMeta, another.nodeMeta);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code address}, {@code datacenter}, {@code serviceName}, {@code serviceId}, {@code serviceAddress}, {@code serviceEnableTagOverride}, {@code servicePort}, {@code serviceTags}, {@code serviceMeta}, {@code serviceWeights}, {@code nodeMeta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + address.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(datacenter);
    h = h * 17 + serviceName.hashCode();
    h = h * 17 + serviceId.hashCode();
    h = h * 17 + serviceAddress.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(serviceEnableTagOverride);
    h = h * 17 + servicePort;
    h = h * 17 + serviceTags.hashCode();
    h = h * 17 + com.google.common.base.Objects.hashCode(serviceMeta);
    h = h * 17 + com.google.common.base.Objects.hashCode(serviceWeights);
    h = h * 17 + com.google.common.base.Objects.hashCode(nodeMeta);
    return h;
  }

  /**
   * Prints the immutable value {@code CatalogService} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogService")
        .omitNullValues()
        .add("node", node)
        .add("address", address)
        .add("datacenter", datacenter)
        .add("serviceName", serviceName)
        .add("serviceId", serviceId)
        .add("serviceAddress", serviceAddress)
        .add("serviceEnableTagOverride", serviceEnableTagOverride)
        .add("servicePort", servicePort)
        .add("serviceTags", serviceTags)
        .add("serviceMeta", serviceMeta)
        .add("serviceWeights", serviceWeights)
        .add("nodeMeta", nodeMeta)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends CatalogService {
    @Nullable String node;
    @Nullable String address;
    Optional<String> datacenter = Optional.empty();
    @Nullable String serviceName;
    @Nullable String serviceId;
    @Nullable String serviceAddress;
    Optional<Boolean> serviceEnableTagOverride = Optional.empty();
    @Nullable Integer servicePort;
    List<String> serviceTags = ImmutableList.of();
    Optional<Map<String, String>> serviceMeta = Optional.empty();
    Optional<ServiceWeights> serviceWeights = Optional.empty();
    Optional<Map<String, String>> nodeMeta = Optional.empty();
    @JsonProperty(value = "Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty(value = "Address")
    public void setAddress(String address) {
      this.address = address;
    }
    @JsonProperty(value = "Datacenter")
    public void setDatacenter(Optional<String> datacenter) {
      this.datacenter = datacenter;
    }
    @JsonProperty(value = "ServiceName")
    public void setServiceName(String serviceName) {
      this.serviceName = serviceName;
    }
    @JsonProperty(value = "ServiceID")
    public void setServiceId(String serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty(value = "ServiceAddress")
    public void setServiceAddress(String serviceAddress) {
      this.serviceAddress = serviceAddress;
    }
    @JsonProperty(value = "ServiceEnableTagOverride")
    public void setServiceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
      this.serviceEnableTagOverride = serviceEnableTagOverride;
    }
    @JsonProperty(value = "ServicePort")
    public void setServicePort(int servicePort) {
      this.servicePort = servicePort;
    }
    @JsonProperty(value = "ServiceTags")
    public void setServiceTags(List<String> serviceTags) {
      this.serviceTags = serviceTags;
    }
    @JsonProperty(value = "ServiceMeta")
    public void setServiceMeta(Optional<Map<String, String>> serviceMeta) {
      this.serviceMeta = serviceMeta;
    }
    @JsonProperty(value = "ServiceWeights")
    public void setServiceWeights(Optional<ServiceWeights> serviceWeights) {
      this.serviceWeights = serviceWeights;
    }
    @JsonProperty(value = "NodeMeta")
    public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
      this.nodeMeta = nodeMeta;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public String getAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getDatacenter() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceAddress() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getServiceEnableTagOverride() { throw new UnsupportedOperationException(); }
    @Override
    public int getServicePort() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getServiceTags() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Map<String, String>> getServiceMeta() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ServiceWeights> getServiceWeights() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Map<String, String>> getNodeMeta() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableCatalogService fromJson(Json json) {
    ImmutableCatalogService.Builder builder = ImmutableCatalogService.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.address != null) {
      builder.address(json.address);
    }
    if (json.datacenter != null) {
      builder.datacenter(json.datacenter);
    }
    if (json.serviceName != null) {
      builder.serviceName(json.serviceName);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceAddress != null) {
      builder.serviceAddress(json.serviceAddress);
    }
    if (json.serviceEnableTagOverride != null) {
      builder.serviceEnableTagOverride(json.serviceEnableTagOverride);
    }
    if (json.servicePort != null) {
      builder.servicePort(json.servicePort);
    }
    if (json.serviceTags != null) {
      builder.addAllServiceTags(json.serviceTags);
    }
    if (json.serviceMeta != null) {
      builder.serviceMeta(json.serviceMeta);
    }
    if (json.serviceWeights != null) {
      builder.serviceWeights(json.serviceWeights);
    }
    if (json.nodeMeta != null) {
      builder.nodeMeta(json.nodeMeta);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CatalogService} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CatalogService instance
   */
  public static ImmutableCatalogService copyOf(CatalogService instance) {
    if (instance instanceof ImmutableCatalogService) {
      return (ImmutableCatalogService) instance;
    }
    return ImmutableCatalogService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCatalogService ImmutableCatalogService}.
   * @return A new ImmutableCatalogService builder
   */
  public static ImmutableCatalogService.Builder builder() {
    return new ImmutableCatalogService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCatalogService ImmutableCatalogService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_ADDRESS = 0x2L;
    private static final long INIT_BIT_SERVICE_NAME = 0x4L;
    private static final long INIT_BIT_SERVICE_ID = 0x8L;
    private static final long INIT_BIT_SERVICE_ADDRESS = 0x10L;
    private static final long INIT_BIT_SERVICE_PORT = 0x20L;
    private long initBits = 0x3f;

    private @Nullable String node;
    private @Nullable String address;
    private @Nullable String datacenter;
    private @Nullable String serviceName;
    private @Nullable String serviceId;
    private @Nullable String serviceAddress;
    private @Nullable Boolean serviceEnableTagOverride;
    private int servicePort;
    private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
    private @Nullable Map<String, String> serviceMeta;
    private @Nullable ServiceWeights serviceWeights;
    private @Nullable Map<String, String> nodeMeta;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CatalogService} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CatalogService instance) {
      Preconditions.checkNotNull(instance, "instance");
      node(instance.getNode());
      address(instance.getAddress());
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      serviceName(instance.getServiceName());
      serviceId(instance.getServiceId());
      serviceAddress(instance.getServiceAddress());
      Optional<Boolean> serviceEnableTagOverrideOptional = instance.getServiceEnableTagOverride();
      if (serviceEnableTagOverrideOptional.isPresent()) {
        serviceEnableTagOverride(serviceEnableTagOverrideOptional);
      }
      servicePort(instance.getServicePort());
      addAllServiceTags(instance.getServiceTags());
      Optional<Map<String, String>> serviceMetaOptional = instance.getServiceMeta();
      if (serviceMetaOptional.isPresent()) {
        serviceMeta(serviceMetaOptional);
      }
      Optional<ServiceWeights> serviceWeightsOptional = instance.getServiceWeights();
      if (serviceWeightsOptional.isPresent()) {
        serviceWeights(serviceWeightsOptional);
      }
      Optional<Map<String, String>> nodeMetaOptional = instance.getNodeMeta();
      if (nodeMetaOptional.isPresent()) {
        nodeMeta(nodeMetaOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getAddress() address} attribute.
     * @param address The value for address 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder address(String address) {
      this.address = Preconditions.checkNotNull(address, "address");
      initBits &= ~INIT_BIT_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Preconditions.checkNotNull(serviceName, "serviceName");
      initBits &= ~INIT_BIT_SERVICE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
      initBits &= ~INIT_BIT_SERVICE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServiceAddress() serviceAddress} attribute.
     * @param serviceAddress The value for serviceAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceAddress(String serviceAddress) {
      this.serviceAddress = Preconditions.checkNotNull(serviceAddress, "serviceAddress");
      initBits &= ~INIT_BIT_SERVICE_ADDRESS;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} to serviceEnableTagOverride.
     * @param serviceEnableTagOverride The value for serviceEnableTagOverride
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceEnableTagOverride(boolean serviceEnableTagOverride) {
      this.serviceEnableTagOverride = serviceEnableTagOverride;
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceEnableTagOverride() serviceEnableTagOverride} to serviceEnableTagOverride.
     * @param serviceEnableTagOverride The value for serviceEnableTagOverride
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
      this.serviceEnableTagOverride = serviceEnableTagOverride.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link CatalogService#getServicePort() servicePort} attribute.
     * @param servicePort The value for servicePort 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePort(int servicePort) {
      this.servicePort = servicePort;
      initBits &= ~INIT_BIT_SERVICE_PORT;
      return this;
    }

    /**
     * Adds one element to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param element A serviceTags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addServiceTags(String element) {
      serviceTagsBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements An array of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addServiceTags(String... elements) {
      serviceTagsBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceTags(Iterable<String> elements) {
      serviceTagsBuilder = ImmutableList.builder();
      return addAllServiceTags(elements);
    }

    /**
     * Adds elements to {@link CatalogService#getServiceTags() serviceTags} list.
     * @param elements An iterable of serviceTags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceTags(Iterable<String> elements) {
      serviceTagsBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceMeta() serviceMeta} to serviceMeta.
     * @param serviceMeta The value for serviceMeta
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceMeta(Map<String, String> serviceMeta) {
      this.serviceMeta = Preconditions.checkNotNull(serviceMeta, "serviceMeta");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceMeta() serviceMeta} to serviceMeta.
     * @param serviceMeta The value for serviceMeta
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceMeta(Optional<Map<String, String>> serviceMeta) {
      this.serviceMeta = serviceMeta.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceWeights() serviceWeights} to serviceWeights.
     * @param serviceWeights The value for serviceWeights
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceWeights(ServiceWeights serviceWeights) {
      this.serviceWeights = Preconditions.checkNotNull(serviceWeights, "serviceWeights");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getServiceWeights() serviceWeights} to serviceWeights.
     * @param serviceWeights The value for serviceWeights
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceWeights(Optional<ServiceWeights> serviceWeights) {
      this.serviceWeights = serviceWeights.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getNodeMeta() nodeMeta} to nodeMeta.
     * @param nodeMeta The value for nodeMeta
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeMeta(Map<String, String> nodeMeta) {
      this.nodeMeta = Preconditions.checkNotNull(nodeMeta, "nodeMeta");
      return this;
    }

    /**
     * Initializes the optional value {@link CatalogService#getNodeMeta() nodeMeta} to nodeMeta.
     * @param nodeMeta The value for nodeMeta
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nodeMeta(Optional<Map<String, String>> nodeMeta) {
      this.nodeMeta = nodeMeta.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCatalogService ImmutableCatalogService}.
     * @return An immutable instance of CatalogService
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCatalogService build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCatalogService(
          node,
          address,
          datacenter,
          serviceName,
          serviceId,
          serviceAddress,
          serviceEnableTagOverride,
          servicePort,
          serviceTagsBuilder.build(),
          serviceMeta,
          serviceWeights,
          nodeMeta);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_ADDRESS) != 0) attributes.add("address");
      if ((initBits & INIT_BIT_SERVICE_NAME) != 0) attributes.add("serviceName");
      if ((initBits & INIT_BIT_SERVICE_ID) != 0) attributes.add("serviceId");
      if ((initBits & INIT_BIT_SERVICE_ADDRESS) != 0) attributes.add("serviceAddress");
      if ((initBits & INIT_BIT_SERVICE_PORT) != 0) attributes.add("servicePort");
      return "Cannot build CatalogService, some of required attributes are not set " + attributes;
    }
  }
}
