package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PutOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePutOptions.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PutOptions"})
@Immutable
public final class ImmutablePutOptions extends PutOptions {
  private final @Nullable Long cas;
  private final @Nullable String acquire;
  private final @Nullable String release;
  private final @Nullable String dc;
  private final @Nullable String token;

  private ImmutablePutOptions(
      @Nullable Long cas,
      @Nullable String acquire,
      @Nullable String release,
      @Nullable String dc,
      @Nullable String token) {
    this.cas = cas;
    this.acquire = acquire;
    this.release = release;
    this.dc = dc;
    this.token = token;
  }

  /**
   * @return The value of the {@code cas} attribute
   */
  @Override
  public Optional<Long> getCas() {
    return Optional.ofNullable(cas);
  }

  /**
   * @return The value of the {@code acquire} attribute
   */
  @Override
  public Optional<String> getAcquire() {
    return Optional.ofNullable(acquire);
  }

  /**
   * @return The value of the {@code release} attribute
   */
  @Override
  public Optional<String> getRelease() {
    return Optional.ofNullable(release);
  }

  /**
   * @return The value of the {@code dc} attribute
   */
  @Override
  public Optional<String> getDc() {
    return Optional.ofNullable(dc);
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Optional<String> getToken() {
    return Optional.ofNullable(token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getCas() cas} attribute.
   * @param value The value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withCas(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.cas, newValue)) return this;
    return new ImmutablePutOptions(newValue, this.acquire, this.release, this.dc, this.token);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getCas() cas} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cas
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withCas(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.cas, value)) return this;
    return new ImmutablePutOptions(value, this.acquire, this.release, this.dc, this.token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getAcquire() acquire} attribute.
   * @param value The value for acquire
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withAcquire(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "acquire");
    if (Objects.equals(this.acquire, newValue)) return this;
    return new ImmutablePutOptions(this.cas, newValue, this.release, this.dc, this.token);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getAcquire() acquire} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for acquire
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withAcquire(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.acquire, value)) return this;
    return new ImmutablePutOptions(this.cas, value, this.release, this.dc, this.token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getRelease() release} attribute.
   * @param value The value for release
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withRelease(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "release");
    if (Objects.equals(this.release, newValue)) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, newValue, this.dc, this.token);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getRelease() release} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for release
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withRelease(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.release, value)) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, value, this.dc, this.token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getDc() dc} attribute.
   * @param value The value for dc
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withDc(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "dc");
    if (Objects.equals(this.dc, newValue)) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, newValue, this.token);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getDc() dc} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dc
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withDc(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.dc, value)) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, value, this.token);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PutOptions#getToken() token} attribute.
   * @param value The value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withToken(String value) {
    @Nullable String newValue = Preconditions.checkNotNull(value, "token");
    if (Objects.equals(this.token, newValue)) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PutOptions#getToken() token} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePutOptions withToken(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.token, value)) return this;
    return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePutOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePutOptions
        && equalTo((ImmutablePutOptions) another);
  }

  private boolean equalTo(ImmutablePutOptions another) {
    return Objects.equals(cas, another.cas)
        && Objects.equals(acquire, another.acquire)
        && Objects.equals(release, another.release)
        && Objects.equals(dc, another.dc)
        && Objects.equals(token, another.token);
  }

  /**
   * Computes a hash code from attributes: {@code cas}, {@code acquire}, {@code release}, {@code dc}, {@code token}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + com.google.common.base.Objects.hashCode(cas);
    h = h * 17 + com.google.common.base.Objects.hashCode(acquire);
    h = h * 17 + com.google.common.base.Objects.hashCode(release);
    h = h * 17 + com.google.common.base.Objects.hashCode(dc);
    h = h * 17 + com.google.common.base.Objects.hashCode(token);
    return h;
  }

  /**
   * Prints the immutable value {@code PutOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PutOptions")
        .omitNullValues()
        .add("cas", cas)
        .add("acquire", acquire)
        .add("release", release)
        .add("dc", dc)
        .add("token", token)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PutOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PutOptions instance
   */
  public static ImmutablePutOptions copyOf(PutOptions instance) {
    if (instance instanceof ImmutablePutOptions) {
      return (ImmutablePutOptions) instance;
    }
    return ImmutablePutOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePutOptions ImmutablePutOptions}.
   * @return A new ImmutablePutOptions builder
   */
  public static ImmutablePutOptions.Builder builder() {
    return new ImmutablePutOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePutOptions ImmutablePutOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Long cas;
    private @Nullable String acquire;
    private @Nullable String release;
    private @Nullable String dc;
    private @Nullable String token;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PutOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PutOptions instance) {
      Preconditions.checkNotNull(instance, "instance");
      Optional<Long> casOptional = instance.getCas();
      if (casOptional.isPresent()) {
        cas(casOptional);
      }
      Optional<String> acquireOptional = instance.getAcquire();
      if (acquireOptional.isPresent()) {
        acquire(acquireOptional);
      }
      Optional<String> releaseOptional = instance.getRelease();
      if (releaseOptional.isPresent()) {
        release(releaseOptional);
      }
      Optional<String> dcOptional = instance.getDc();
      if (dcOptional.isPresent()) {
        dc(dcOptional);
      }
      Optional<String> tokenOptional = instance.getToken();
      if (tokenOptional.isPresent()) {
        token(tokenOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for chained invocation
     */
    public final Builder cas(long cas) {
      this.cas = cas;
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getCas() cas} to cas.
     * @param cas The value for cas
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cas(Optional<Long> cas) {
      this.cas = cas.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getAcquire() acquire} to acquire.
     * @param acquire The value for acquire
     * @return {@code this} builder for chained invocation
     */
    public final Builder acquire(String acquire) {
      this.acquire = Preconditions.checkNotNull(acquire, "acquire");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getAcquire() acquire} to acquire.
     * @param acquire The value for acquire
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder acquire(Optional<String> acquire) {
      this.acquire = acquire.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getRelease() release} to release.
     * @param release The value for release
     * @return {@code this} builder for chained invocation
     */
    public final Builder release(String release) {
      this.release = Preconditions.checkNotNull(release, "release");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getRelease() release} to release.
     * @param release The value for release
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder release(Optional<String> release) {
      this.release = release.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getDc() dc} to dc.
     * @param dc The value for dc
     * @return {@code this} builder for chained invocation
     */
    public final Builder dc(String dc) {
      this.dc = Preconditions.checkNotNull(dc, "dc");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getDc() dc} to dc.
     * @param dc The value for dc
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dc(Optional<String> dc) {
      this.dc = dc.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for chained invocation
     */
    public final Builder token(String token) {
      this.token = Preconditions.checkNotNull(token, "token");
      return this;
    }

    /**
     * Initializes the optional value {@link PutOptions#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Optional<String> token) {
      this.token = token.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePutOptions ImmutablePutOptions}.
     * @return An immutable instance of PutOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePutOptions build() {
      return new ImmutablePutOptions(cas, acquire, release, dc, token);
    }
  }
}
