/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.pili;

import com.qiniu.pili.Hub;
import com.qiniu.pili.Mac;
import com.qiniu.pili.Meeting;
import com.qiniu.pili.RPC;

public final class Client {
    private RPC cli;

    public Client(String accessKey, String secretKey) {
        this.cli = new RPC(new Mac(accessKey, secretKey));
    }

    public String RTMPPublishURL(String domain, String hub, String streamKey, int expireAfterSeconds) {
        String token;
        long expire = System.currentTimeMillis() / 1000L + (long)expireAfterSeconds;
        String path = String.format("/%s/%s?e=%d", hub, streamKey, expire);
        try {
            token = this.cli.getMac().sign(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return String.format("rtmp://%s%s&token=%s", domain, path, token);
    }

    public String RTMPPlayURL(String domain, String hub, String streamKey) {
        return String.format("rtmp://%s/%s/%s", domain, hub, streamKey);
    }

    public String HLSPlayURL(String domain, String hub, String streamKey) {
        return String.format("http://%s/%s/%s.m3u8", domain, hub, streamKey);
    }

    public String HDLPlayURL(String domain, String hub, String streamKey) {
        return String.format("http://%s/%s/%s.flv", domain, hub, streamKey);
    }

    public String SnapshotPlayURL(String domain, String hub, String streamKey) {
        return String.format("http://%s/%s/%s.jpg", domain, hub, streamKey);
    }

    public Hub newHub(String hub) {
        return new Hub(this.cli, hub);
    }

    public Meeting newMeeting() {
        return new Meeting(this.cli);
    }
}

