/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.pili;

import com.google.gson.Gson;
import com.qiniu.pili.Config;
import com.qiniu.pili.PiliException;
import com.qiniu.pili.RPC;
import com.qiniu.pili.Stream;
import com.qiniu.pili.StreamInfo;
import com.qiniu.pili.utils.UrlSafeBase64;

public final class Hub {
    private RPC cli;
    private String hub;
    private String baseUrl;
    private Gson gson;

    private Hub() {
    }

    Hub(RPC cli, String hub) {
        this.cli = cli;
        this.hub = hub;
        this.baseUrl = "http://" + Config.APIHost + "/v2/hubs/" + hub;
        this.gson = new Gson();
    }

    public Stream create(String streamKey) throws PiliException {
        String path = this.baseUrl + "/streams";
        CreateArgs args = new CreateArgs(streamKey);
        String json = this.gson.toJson((Object)args);
        try {
            this.cli.callWithJson(path, json);
            StreamInfo streamInfo = new StreamInfo(this.hub, streamKey);
            return new Stream(streamInfo, this.cli);
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public Stream get(String streamKey) throws PiliException {
        try {
            String ekey = UrlSafeBase64.encodeToString(streamKey);
            String path = this.baseUrl + "/streams/" + ekey;
            String resp = this.cli.callWithGet(path);
            StreamInfo ret = (StreamInfo)this.gson.fromJson(resp, StreamInfo.class);
            ret.setMeta(this.hub, streamKey);
            return new Stream(ret, this.cli);
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    private ListRet list(boolean live, String prefix, int limit, String marker) throws PiliException {
        String path = String.format("%s/streams?liveonly=%s&prefix=%s&limit=%d&marker=%s", this.baseUrl, live, prefix, limit, marker);
        try {
            String resp = this.cli.callWithGet(path);
            ApiRet ret = (ApiRet)this.gson.fromJson(resp, ApiRet.class);
            ListRet listRet = new ListRet();
            listRet.keys = new String[ret.items.length];
            for (int i = 0; i < ret.items.length; ++i) {
                listRet.keys[i] = ret.items[i].key;
            }
            listRet.omarker = ret.marker;
            return listRet;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public ListRet list(String prefix, int limit, String marker) throws PiliException {
        return this.list(false, prefix, limit, marker);
    }

    public ListRet listLive(String prefix, int limit, String marker) throws PiliException {
        return this.list(true, prefix, limit, marker);
    }

    public BatchLiveStatus[] batchLiveStatus(String[] streamTitles) throws PiliException {
        String path = this.baseUrl + "/livestreams";
        String json = this.gson.toJson((Object)new BatchLiveStatusOptions(streamTitles));
        try {
            String resp = this.cli.callWithJson(path, json);
            BatchLiveStatusRet ret = (BatchLiveStatusRet)this.gson.fromJson(resp, BatchLiveStatusRet.class);
            return ret.items;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    private class ApiRet {
        ListItem[] items;
        String marker;

        private ApiRet() {
        }
    }

    private class ListItem {
        String key;

        private ListItem() {
        }
    }

    public class ListRet {
        public String[] keys;
        public String omarker;
    }

    private class CreateArgs {
        String key;

        public CreateArgs(String key) {
            this.key = key;
        }
    }

    public class BatchLiveStatus
    extends Stream.LiveStatus {
        String key;
    }

    private class BatchLiveStatusRet {
        BatchLiveStatus[] items;

        private BatchLiveStatusRet() {
        }
    }

    private class BatchLiveStatusOptions {
        String[] items;

        public BatchLiveStatusOptions(String[] items) {
            this.items = items;
        }
    }
}

