/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.pili;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.qiniu.pili.Config;
import com.qiniu.pili.PiliException;
import com.qiniu.pili.RPC;
import java.util.Date;

public class Meeting {
    private String baseUrl;
    private Gson gson;
    private RPC cli;

    private Meeting() {
    }

    Meeting(RPC cli) {
        this.baseUrl = "http://" + Config.RTCAPIHost + "/v1";
        this.cli = cli;
        this.gson = new Gson();
    }

    public String createRoom(String ownerId, String roomName, int userMax) throws PiliException {
        CreateArgs args = new CreateArgs(ownerId, roomName, userMax);
        return this.createRoom(args);
    }

    public String createRoom(String ownerId, String roomName) throws PiliException {
        CreateArgs args = new CreateArgs(ownerId, roomName);
        return this.createRoom(args);
    }

    public String createRoom(String ownerId) throws PiliException {
        CreateArgs args = new CreateArgs(ownerId);
        return this.createRoom(args);
    }

    private String createRoom(CreateArgs args) throws PiliException {
        String path = this.baseUrl + "/rooms";
        String json = this.gson.toJson((Object)args);
        try {
            String resp = this.cli.callWithJson(path, json);
            RoomName ret = (RoomName)this.gson.fromJson(resp, RoomName.class);
            return ret.roomName;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
    }

    public Room getRoom(String roomName) throws PiliException {
        String path = this.baseUrl + "/rooms/" + roomName;
        try {
            String resp = this.cli.callWithGet(path);
            Room room = (Room)this.gson.fromJson(resp, Room.class);
            return room;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
    }

    public void deleteRoom(String room) throws PiliException {
        String path = this.baseUrl + "/rooms/" + room;
        try {
            this.cli.callWithDelete(path);
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
    }

    public AllActiveUsers activeUsers(String roomName) throws PiliException {
        String path = this.baseUrl + "/rooms/" + roomName + "/users";
        try {
            String resp = this.cli.callWithGet(path);
            AllActiveUsers us = (AllActiveUsers)this.gson.fromJson(resp, AllActiveUsers.class);
            return us;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
    }

    public void rejectUser(String roomName, String userId) throws PiliException {
        String path = this.baseUrl + "/rooms/" + roomName + "/users/" + userId;
        try {
            this.cli.callWithDelete(path);
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PiliException(e);
        }
    }

    public String roomToken(String roomName, String userId, String perm, Date expireAt) throws Exception {
        RoomAccess access = new RoomAccess(roomName, userId, perm, expireAt);
        String json = this.gson.toJson((Object)access);
        return this.cli.getMac().signRoomToken(json);
    }

    public class AllActiveUsers {
        @SerializedName(value="active_users")
        public ActiveUser[] users;
    }

    public class ActiveUser {
        @SerializedName(value="user_id")
        public String userId;
        @SerializedName(value="user_name")
        public String userName;
    }

    private class CreateArgs {
        @SerializedName(value="owner_id")
        String ownerId;
        @SerializedName(value="room_name")
        String room;
        @SerializedName(value="user_max")
        int userMax;

        public CreateArgs(String ownerId, String room, int userMax) {
            this.ownerId = ownerId;
            this.room = room;
            this.userMax = userMax;
        }

        public CreateArgs(String ownerId, String room) {
            this.ownerId = ownerId;
            this.room = room;
        }

        public CreateArgs(String ownerId) {
            this.ownerId = ownerId;
        }
    }

    private class RoomName {
        @SerializedName(value="room_name")
        String roomName;

        private RoomName() {
        }
    }

    public class Room {
        @SerializedName(value="room_name")
        public String name;
        @SerializedName(value="room_status")
        public Status status;
        @SerializedName(value="owner_id")
        public String ownerId;
        @SerializedName(value="user_max")
        public int userMaxe;
    }

    public static enum Status {
        NEW,
        MEETING,
        FINISHED;

    }

    private class RoomAccess {
        @SerializedName(value="room_name")
        String roomName;
        @SerializedName(value="user_id")
        String userId;
        @SerializedName(value="perm")
        String perm;
        @SerializedName(value="expire_at")
        long expireAt;

        RoomAccess(String roomName, String userId, String perm, Date expireAt) {
            this.roomName = roomName;
            this.userId = userId;
            this.perm = perm;
            this.expireAt = expireAt.getTime() / 1000L;
        }
    }
}

