/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.pili;

import okhttp3.Response;

public class PiliException
extends Exception {
    public final Response response;
    private final String ErrNotFound = "stream not found";
    private final String ErrDuplicate = "stream already exists";
    private final String ErrNotLive = "no data";

    public PiliException(Response response) {
        this.response = response;
    }

    public PiliException(String msg) {
        super(msg);
        this.response = null;
    }

    public PiliException(Exception e) {
        super(e);
        this.response = null;
    }

    public int code() {
        return this.response == null ? -1 : this.response.code();
    }

    public boolean isDuplicate() {
        return this.code() == 614;
    }

    public boolean isNotFound() {
        return this.code() == 612;
    }

    public boolean isNotInLive() {
        return this.code() == 619;
    }

    @Override
    public String getMessage() {
        if (this.response == null) {
            return super.getMessage();
        }
        switch (this.code()) {
            case 614: {
                return "stream already exists";
            }
            case 612: {
                return "stream not found";
            }
            case 619: {
                return "no data";
            }
        }
        return this.response.message();
    }
}

