/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.pili;

import com.google.gson.Gson;
import com.qiniu.pili.Config;
import com.qiniu.pili.PiliException;
import com.qiniu.pili.RPC;
import com.qiniu.pili.StreamInfo;
import com.qiniu.pili.utils.UrlSafeBase64;
import java.io.UnsupportedEncodingException;

public final class Stream {
    private StreamInfo info;
    private String baseUrl;
    private RPC cli;
    private Gson gson;

    private Stream() {
    }

    Stream(StreamInfo info, RPC cli) throws UnsupportedEncodingException {
        this.info = info;
        String ekey = UrlSafeBase64.encodeToString(info.getKey());
        this.baseUrl = String.format("%s%s/v2/hubs/%s/streams/%s", "http://", Config.APIHost, info.getHub(), ekey);
        this.cli = cli;
        this.gson = new Gson();
    }

    public String getHub() {
        return this.info.getHub();
    }

    public long getDisabledTill() {
        return this.info.getDisabledTill();
    }

    public String[] getConverts() {
        return this.info.getConverts();
    }

    public String getKey() {
        return this.info.getKey();
    }

    private void setDisabledTill(long disabledTill) throws PiliException {
        DisabledArgs args = new DisabledArgs(disabledTill);
        String path = this.baseUrl + "/disabled";
        String json = this.gson.toJson((Object)args);
        try {
            this.cli.callWithJson(path, json);
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    private String appendQuery(String path, long start, long end) {
        String flag = "?";
        if (start > 0L) {
            path = path + String.format("%sstart=%d", flag, start);
            flag = "&";
        }
        if (end > 0L) {
            path = path + String.format("%send=%d", flag, end);
        }
        return path;
    }

    public String toJson() {
        return this.gson.toJson((Object)this.info);
    }

    public Stream info() throws PiliException {
        try {
            String resp = this.cli.callWithGet(this.baseUrl);
            StreamInfo ret = (StreamInfo)this.gson.fromJson(resp, StreamInfo.class);
            ret.setMeta(this.info.getHub(), this.info.getKey());
            this.info = ret;
            return this;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public void disable() throws PiliException {
        this.setDisabledTill(-1L);
    }

    public void disable(long disabledTill) throws PiliException {
        this.setDisabledTill(disabledTill);
    }

    public void enable() throws PiliException {
        this.setDisabledTill(0L);
    }

    public LiveStatus liveStatus() throws PiliException {
        String path = this.baseUrl + "/live";
        try {
            String resp = this.cli.callWithGet(path);
            LiveStatus status = (LiveStatus)this.gson.fromJson(resp, LiveStatus.class);
            return status;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public String save(long start, long end) throws PiliException {
        SaveOptions args = new SaveOptions(start, end);
        return this.save(args);
    }

    public String save(SaveOptions opts) throws PiliException {
        String path = this.baseUrl + "/saveas";
        String json = this.gson.toJson((Object)opts);
        try {
            String resp = this.cli.callWithJson(path, json);
            SaveRet ret = (SaveRet)this.gson.fromJson(resp, SaveRet.class);
            return ret.fname;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public String snapshot(SnapshotOptions opts) throws PiliException {
        String path = this.baseUrl + "/snapshot";
        String json = this.gson.toJson((Object)opts);
        try {
            String resp = this.cli.callWithJson(path, json);
            SnapshotRet ret = (SnapshotRet)this.gson.fromJson(resp, SnapshotRet.class);
            return ret.fname;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public void updateConverts(String[] profiles) throws PiliException {
        String path = this.baseUrl + "/converts";
        String json = this.gson.toJson((Object)new ConvertsOptions(profiles));
        try {
            this.cli.callWithJson(path, json);
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    public Record[] historyRecord(long start, long end) throws PiliException {
        String path = this.appendQuery(this.baseUrl + "/historyrecord", start, end);
        try {
            String resp = this.cli.callWithGet(path);
            HistoryRet ret = (HistoryRet)this.gson.fromJson(resp, HistoryRet.class);
            return ret.items;
        }
        catch (PiliException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PiliException(e);
        }
    }

    private class HistoryRet {
        Record[] items;

        private HistoryRet() {
        }
    }

    public class Record {
        public long start;
        public long end;
    }

    private class ConvertsOptions {
        String[] converts;

        public ConvertsOptions(String[] converts) {
            this.converts = converts;
        }
    }

    private class SnapshotRet {
        String fname;

        private SnapshotRet() {
        }
    }

    public static class SnapshotOptions {
        public String fname;
        public long time;
        public String format;

        public SnapshotOptions() {
        }

        public SnapshotOptions(String fname, long time, String format) {
            this.fname = fname;
            this.time = time;
            this.format = format;
        }
    }

    private class SaveRet {
        String fname;

        private SaveRet() {
        }
    }

    public static class SaveOptions {
        public long start;
        public long end;
        public String fname;
        public String format;
        public String pipeline;
        public String notify;
        public long expireDays;

        public SaveOptions() {
        }

        public SaveOptions(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }

    public static class LiveStatus {
        public long startAt;
        public String clientIP;
        public int bps;
        public FPSStatus fps;

        public String toJson() {
            return new Gson().toJson((Object)this);
        }
    }

    public class FPSStatus {
        public int audio;
        public int video;
        public int data;
    }

    private class DisabledArgs {
        long disabledTill;

        public DisabledArgs(long disabledTill) {
            this.disabledTill = disabledTill;
        }
    }
}

