/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.AbstractDockerMojo;
import com.spotify.docker.Utils;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ImageNotFoundException;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.shaded.javax.ws.rs.NotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="removeImage")
public class RemoveImageMojo
extends AbstractDockerMojo {
    @Parameter(property="imageName", required=true)
    private String imageName;
    @Parameter(property="dockerImageTags")
    private List<String> imageTags;

    @Override
    protected void execute(DockerClient docker) throws MojoExecutionException, DockerException, IOException, InterruptedException {
        String imageNameWithoutTag = Utils.parseImageName(this.imageName)[0];
        if (this.imageTags == null) {
            this.imageTags = Collections.singletonList("");
        }
        for (String imageTag : this.imageTags) {
            String currImageName = imageNameWithoutTag + (Strings.isNullOrEmpty((String)imageTag) ? "" : ":" + imageTag);
            this.getLog().info((CharSequence)("Removing -f " + currImageName));
            try {
                for (RemovedImage removedImage : docker.removeImage(currImageName, true, false)) {
                    this.getLog().info((CharSequence)("Removed: " + removedImage.imageId()));
                }
            }
            catch (ImageNotFoundException | NotFoundException e) {
                this.getLog().warn((CharSequence)("Image " + this.imageName + " doesn't exist and cannot be deleted - ignoring"));
            }
        }
    }
}

