/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.webcomponentshelper.htmlbundle;

import com.vaadin.server.BootstrapHandler;
import com.vaadin.server.DependencyFilter;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceInitEvent;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServiceInitListener;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Dependency;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HtmlBundleHandler
implements DependencyFilter,
VaadinServiceInitListener {
    public static final String HTML_BUNDLE_NAME = "html-bundle";

    public void serviceInit(ServiceInitEvent event) {
        event.addDependencyFilter((DependencyFilter)this);
    }

    public List<Dependency> filter(List<Dependency> deps, DependencyFilter.FilterContext context) {
        String bundleName = HtmlBundleHandler.getHtmlBundleName(context.getSession());
        if (bundleName == null) {
            return deps;
        }
        ArrayList<Dependency> newDeps = new ArrayList<Dependency>();
        boolean bundleAdded = false;
        for (Dependency dep : deps) {
            if (dep.getType() == Dependency.Type.HTMLIMPORT && dep.getUrl().startsWith("frontend://")) {
                if (bundleAdded) continue;
                newDeps.add(new Dependency(Dependency.Type.HTMLIMPORT, bundleName));
                bundleAdded = true;
                continue;
            }
            newDeps.add(dep);
        }
        return newDeps;
    }

    private static String getHtmlBundleName(VaadinSession session) {
        VaadinService vaadinService = session.getService();
        DeploymentConfiguration deploymentConfiguration = vaadinService.getDeploymentConfiguration();
        String definedBundleName = deploymentConfiguration.getApplicationOrSystemProperty(HTML_BUNDLE_NAME, null);
        if (definedBundleName != null) {
            if ("".equals(definedBundleName)) {
                return null;
            }
            return definedBundleName;
        }
        if (!(vaadinService instanceof VaadinServletService)) {
            return null;
        }
        String bundleUrl = BootstrapHandler.resolveFrontendUrl((VaadinSession)session) + "bundle.html";
        String bundleFileName = bundleUrl.replace("vaadin://", "/VAADIN/");
        VaadinServlet servlet = ((VaadinServletService)vaadinService).getServlet();
        try {
            URL autoDetected = servlet.findResourceURL(bundleFileName);
            if (autoDetected != null) {
                return bundleUrl;
            }
        }
        catch (IOException e) {
            HtmlBundleHandler.getLogger().log(Level.FINE, "Error finding default bundle " + bundleFileName, e);
        }
        return null;
    }

    private static Logger getLogger() {
        return Logger.getLogger(HtmlBundleHandler.class.getName());
    }
}

