/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.web;

import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.web.AdminController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

@AdminController
public class UiController {
    private final String adminContextPath;
    private final List<UiExtension> cssExtensions;
    private final List<UiExtension> jsExtensions;
    private final Map<String, Object> uiSettings;

    public UiController(String adminContextPath, String title, String brand, List<UiExtension> uiExtensions) {
        this.adminContextPath = adminContextPath;
        this.uiSettings = new HashMap<String, Object>();
        this.uiSettings.put("title", title);
        this.uiSettings.put("brand", brand);
        this.cssExtensions = uiExtensions.stream().filter(e -> e.getResourcePath().endsWith(".css")).collect(Collectors.toList());
        this.jsExtensions = uiExtensions.stream().filter(e -> e.getResourcePath().endsWith(".js")).collect(Collectors.toList());
    }

    @ModelAttribute(value="adminContextPath", binding=false)
    public String getAdminContextPath() {
        return this.adminContextPath;
    }

    @ModelAttribute(value="uiSettings", binding=false)
    public Map<String, Object> getUiSettings() {
        return this.uiSettings;
    }

    @ModelAttribute(value="cssExtensions", binding=false)
    public List<UiExtension> getCssExtensions() {
        return this.cssExtensions;
    }

    @ModelAttribute(value="jsExtensions", binding=false)
    public List<UiExtension> getJsExtensions() {
        return this.jsExtensions;
    }

    @ModelAttribute(value="user", binding=false)
    public Map<String, Object> getUiSettings(Principal principal) {
        if (principal != null) {
            return Collections.singletonMap("name", principal.getName());
        }
        return Collections.emptyMap();
    }

    @GetMapping(path={"/"}, produces={"text/html"})
    public String index() {
        return "index";
    }

    @GetMapping(path={"/login"}, produces={"text/html"})
    public String login() {
        return "login";
    }
}

