/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import java.util.Optional;
import java.util.function.Function;

public interface PackageFinder {
    public Optional<Package> packageFor(Distribution var1);

    public static PackageFinder failWithMessage(Function<Distribution, String> messageFactory) {
        return new FailWithMessage(messageFactory);
    }

    public static class FailWithMessage
    implements PackageFinder,
    HasExplanation {
        private final Function<Distribution, String> messageFactory;

        public FailWithMessage(Function<Distribution, String> messageFactory) {
            this.messageFactory = messageFactory;
        }

        @Override
        public Optional<Package> packageFor(Distribution distribution) {
            throw new IllegalArgumentException(this.messageFactory.apply(distribution));
        }

        @Override
        public String explain() {
            return "fail";
        }
    }
}

