/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.collections;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.collections.GeneratedImmutableTypedMap;
import de.flapdoodle.collections.MutableTypedMap;
import de.flapdoodle.collections.TypedMap;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Pair;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(typeImmutable="Generated*")
public abstract class ImmutableTypedMap<K>
implements TypedMap<K> {
    protected abstract Map<Pair<K, ? extends TypeInfo<?>>, Object> map();

    @Override
    @Value.Auxiliary
    public <T> T get(TypeInfo<T> type, K key) {
        return (T)this.map().get(Pair.of(key, type));
    }

    @Override
    @Value.Lazy
    public Set<Pair<K, ? extends TypeInfo<?>>> keySet() {
        return this.map().keySet();
    }

    @Value.Auxiliary
    public MutableTypedMap<K> asMutable() {
        return new MutableTypedMap(this.map());
    }

    @Value.Auxiliary
    public <T> ImmutableTypedMap<K> add(TypeInfo<T> type, K key, T value) {
        Preconditions.checkNotNull(value, "value is null", new Object[0]);
        Pair mapKey = Pair.of(key, type);
        Preconditions.checkArgument(!this.map().containsKey(mapKey), "key %s:%s already set to %s", key, type, Preconditions.lazy(() -> this.map().get(mapKey)));
        return GeneratedImmutableTypedMap.builder().from(this).putMap(mapKey, value).build();
    }

    @Value.Auxiliary
    public <T> ImmutableTypedMap<K> addAll(TypeInfo<T> type, Map<K, T> map) {
        GeneratedImmutableTypedMap.Builder builder = GeneratedImmutableTypedMap.builder().from(this);
        map.forEach((key, value) -> {
            Preconditions.checkNotNull(value, "value is null", new Object[0]);
            Pair<Object, TypeInfo> mapKey = Pair.of(key, type);
            Preconditions.checkArgument(!this.map().containsKey(mapKey), "key %s:%s already set to %s", key, type, Preconditions.lazy(() -> this.map().get(mapKey)));
            builder.putMap(mapKey, value);
        });
        return builder.build();
    }

    public static <K> ImmutableTypedMap<K> empty() {
        return GeneratedImmutableTypedMap.builder().build();
    }

    public static <K, T> ImmutableTypedMap<K> of(TypeInfo<T> type, K key, T value) {
        return ImmutableTypedMap.empty().add(type, key, value);
    }

    public static <K, T> ImmutableTypedMap<K> of(TypeInfo<T> type, Map<K, T> map) {
        return ImmutableTypedMap.empty().addAll(type, map);
    }

    public static <K> ImmutableTypedMap<K> copyOf(TypedMap<K> src) {
        if (src instanceof ImmutableTypedMap) {
            return (ImmutableTypedMap)src;
        }
        GeneratedImmutableTypedMap.Builder builder = GeneratedImmutableTypedMap.builder();
        src.keySet().forEach(key -> builder.putMap(key, src.get((TypeInfo)key.second(), key.first())));
        return builder.build();
    }
}

