/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.SignedJars;
import dev.equo.solstice.SolsticeManifest;
import dev.equo.solstice.Unchecked;
import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public abstract class NestedJars {
    public static final String DIR = "nested-jars";
    private static final Attributes.Name CLASSPATH = new Attributes.Name("Bundle-ClassPath");
    private static OnClassPath onClassPath;
    private static boolean warnOnly;

    public static String solsticeVersion() {
        String solsticeJar = NestedJars.class.getResource(NestedJars.class.getSimpleName() + ".class").toString();
        if (!solsticeJar.startsWith("jar")) {
            return "SNAPSHOT-";
        }
        try {
            URL url = new URL(solsticeJar);
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Manifest manifest = jarConnection.getManifest();
            return manifest.getMainAttributes().getValue("Implementation-Version");
        }
        catch (IOException e) {
            throw Unchecked.wrap(e);
        }
    }

    @Deprecated
    public static Collection<String> transitiveDeps(boolean useAtomos, CoordFormat format) {
        return NestedJars.transitiveDeps(useAtomos, format, null);
    }

    public static Collection<String> transitiveDeps(boolean useAtomos, CoordFormat format, P2QueryResult query) {
        String VER_SLF4J;
        boolean needsApi = true;
        boolean needsSimple = true;
        boolean slf4j_is_2 = false;
        if (query != null) {
            Iterator iter = Stream.concat(query.getJarsOnMavenCentral().stream(), query.getJarsNotOnMavenCentral().stream().map(File::getName)).iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (name.contains("slf4j-nop")) continue;
                if (name.contains("slf4j")) {
                    if (name.contains("slf4j-api") || name.contains("slf4j.api")) {
                        needsApi = false;
                        slf4j_is_2 = name.contains("slf4j.api_2.") || name.contains("slf4j-api_2.");
                        continue;
                    }
                    needsSimple = false;
                    continue;
                }
                if (!name.contains("logback-classic")) continue;
                needsSimple = false;
            }
        }
        ArrayList<String> coords = new ArrayList<String>();
        String string = VER_SLF4J = slf4j_is_2 ? "2.0.7" : "1.7.36";
        if (needsApi) {
            coords.add(format.format("org.slf4j", "slf4j-api", VER_SLF4J, null));
        }
        if (needsSimple) {
            coords.add(format.format("org.slf4j", "slf4j-simple", VER_SLF4J, null));
        }
        if (useAtomos) {
            coords.add(format.format("org.apache.felix", "org.apache.felix.atomos", "1.0.0", null));
            coords.add(format.format("org.apache.felix.atomos", "osgi.core", "8.0.0", "AtomosEquinox"));
        }
        return coords;
    }

    private static void addNestedJarsFromManifest(List<URL> nestedJars, String jarUrl, InputStream stream) throws IOException {
        Manifest manifest = new Manifest(stream);
        String cp = manifest.getMainAttributes().getValue(CLASSPATH);
        if (cp != null) {
            String[] lines;
            for (String lineRaw : lines = cp.split(",")) {
                String line = lineRaw.trim();
                if (line.startsWith("../")) {
                    LoggerFactory.getLogger(NestedJars.class).warn("Ignoring unexpected nested jar " + line + " inside " + jarUrl);
                    continue;
                }
                if (line.equals(".")) continue;
                URL nestedJar = Unchecked.get(() -> new URL(jarUrl + "/" + line));
                nestedJars.add(nestedJar);
            }
        }
    }

    public static OnClassPath onClassPath() {
        if (onClassPath == null) {
            onClassPath = new OnClassPath();
        }
        return onClassPath;
    }

    public static NestedJars inFiles(final Iterable<File> files) {
        return new NestedJars(){

            @Override
            protected List<URL> listNestedJars() {
                ArrayList<URL> nestedJars = new ArrayList<URL>();
                for (File file : files) {
                    try (JarFile jarFile = new JarFile(file);){
                        ZipEntry zipEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                        if (zipEntry == null) continue;
                        String jarUrl = "jar:" + file.toURI().toURL().toExternalForm() + "!";
                        InputStream input = jarFile.getInputStream(zipEntry);
                        try {
                            NestedJars.addNestedJarsFromManifest(nestedJars, jarUrl, input);
                        }
                        finally {
                            if (input == null) continue;
                            input.close();
                        }
                    }
                    catch (IOException e) {
                        throw Unchecked.wrap(e);
                    }
                }
                return nestedJars;
            }
        };
    }

    protected abstract List<URL> listNestedJars();

    public List<Map.Entry<URL, File>> extractAllNestedJars() {
        return this.extractAllNestedJars(CacheLocations.p2nestedJars());
    }

    public List<Map.Entry<URL, File>> extractAllNestedJars(File nestedJarFolder) {
        ArrayList<Map.Entry<URL, File>> files = new ArrayList<Map.Entry<URL, File>>();
        for (URL url : this.listNestedJars()) {
            int lastExclamation = url.getPath().indexOf(33);
            int slashBeforeThat = url.getPath().lastIndexOf(47, lastExclamation);
            try {
                files.add(NestedJars.extractNestedJar(url.getPath().substring(slashBeforeThat + 1, lastExclamation), url, nestedJarFolder));
            }
            catch (FileNotFoundException e2) {
                LoggerFactory.getLogger(NestedJars.class).warn("Missing nested jar: " + url.getPath());
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
        files.sort(Comparator.comparing(e -> ((URL)e.getKey()).getPath()));
        return files;
    }

    public static void setToWarnOnly() {
        warnOnly = true;
    }

    private static Map.Entry<URL, File> extractNestedJar(String parentJar, URL entry, File nestedJarFolder) throws IOException {
        try (InputStream toRead = entry.openStream();){
            byte[] content = toRead.readAllBytes();
            String jarPath = entry.getPath();
            int lastSep = Math.max(jarPath.lastIndexOf(33), jarPath.lastIndexOf(47));
            String jarSimpleName = jarPath.substring(lastSep + 1);
            String filename = parentJar + "__" + jarSimpleName + "__" + NestedJars.filenameSafeHash(content) + ".jar";
            File jarToAdd = new File(nestedJarFolder, filename);
            if (!jarToAdd.exists() || jarToAdd.length() != (long)content.length) {
                nestedJarFolder.mkdirs();
                try (FileOutputStream output = new FileOutputStream(jarToAdd);){
                    output.write(content);
                }
            }
            Map.Entry<URL, File> entry2 = Map.entry(entry, jarToAdd);
            return entry2;
        }
    }

    static String filenameSafeHash(String content) {
        return NestedJars.filenameSafeHash(content.getBytes(StandardCharsets.UTF_8));
    }

    static String filenameSafeHash(byte[] content) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(content);
            String encoded = new String(Base64.getEncoder().encode(md5.digest()), StandardCharsets.US_ASCII);
            return encoded.replace('/', '-').replace('=', '-');
        }
        catch (NoSuchAlgorithmException e) {
            throw Unchecked.wrap(e);
        }
    }

    static {
        warnOnly = false;
    }

    public static enum CoordFormat {
        GRADLE,
        MAVEN;


        private String format(String g, String a, String version, @Nullable String c) {
            if (c == null) {
                return g + ":" + a + ":" + version;
            }
            if (this == GRADLE) {
                return g + ":" + a + ":" + version + ":" + c;
            }
            if (this == MAVEN) {
                return g + ":" + a + ":jar:" + c + ":" + version;
            }
            throw new IllegalArgumentException("Unknown format " + this);
        }
    }

    public static class OnClassPath
    extends NestedJars {
        private Set<File> nestedJarsOnClasspath;
        private static final String JAR_COLON_FILE_COLON = "jar:file:";

        private OnClassPath() {
        }

        @Override
        protected List<URL> listNestedJars() {
            ArrayList<URL> nestedJars = new ArrayList<URL>();
            Enumeration manifests = Unchecked.get(() -> NestedJars.class.getClassLoader().getResources("META-INF/MANIFEST.MF"));
            while (manifests.hasMoreElements()) {
                URL manifestUrl = (URL)manifests.nextElement();
                String fullUrl = manifestUrl.toExternalForm();
                String jarUrl = fullUrl.substring(0, fullUrl.length() - "/META-INF/MANIFEST.MF".length());
                try {
                    InputStream stream = manifestUrl.openStream();
                    try {
                        NestedJars.addNestedJarsFromManifest(nestedJars, jarUrl, stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw Unchecked.wrap(e);
                }
            }
            return nestedJars;
        }

        public void confirmAllNestedJarsArePresentOnClasspath(File nestedJarFolder) {
            this.nestedJarsOnClasspath = new HashSet<File>();
            List<Map.Entry<URL, File>> entries = this.extractAllNestedJars(nestedJarFolder);
            entries.removeIf(entry -> {
                if (!((File)entry.getValue()).exists()) return false;
                try (JarFile jarFile = new JarFile((File)entry.getValue());){
                    String url;
                    String targetPrefix = "jar:" + ((File)entry.getValue()).toURI() + "!";
                    String targetPrefixStripped = "jar:" + SignedJars.strippedFile((File)entry.getValue()).toURI() + "!";
                    String firstResource = jarFile.entries().nextElement().getName();
                    Enumeration<URL> onTheClasspath = NestedJars.class.getClassLoader().getResources(firstResource);
                    do {
                        if (!onTheClasspath.hasMoreElements()) return false;
                    } while (!(url = onTheClasspath.nextElement().toExternalForm()).startsWith(targetPrefix) && !url.startsWith(targetPrefixStripped));
                    this.nestedJarsOnClasspath.add((File)entry.getValue());
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    throw Unchecked.wrap(e);
                }
            });
            if (!entries.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append("The following nested jars are missing from " + nestedJarFolder.getAbsolutePath() + "\n");
                for (Map.Entry<URL, File> entry2 : entries) {
                    msg.append("  ");
                    msg.append(entry2.getKey().toExternalForm());
                    msg.append('\n');
                }
                if (warnOnly) {
                    LoggerFactory.getLogger(NestedJars.class).warn(msg.toString());
                } else {
                    throw new IllegalStateException(msg.toString());
                }
            }
        }

        public boolean isNestedJar(SolsticeManifest manifest) {
            if (this.nestedJarsOnClasspath == null) {
                throw new IllegalStateException("You must call `confirmAllNestedJarsArePresentOnClasspath` first.");
            }
            if (manifest.getJarUrl().startsWith(JAR_COLON_FILE_COLON) && manifest.getJarUrl().endsWith("!")) {
                String innerUrl = manifest.getJarUrl().substring(JAR_COLON_FILE_COLON.length(), manifest.getJarUrl().length() - 1);
                return this.nestedJarsOnClasspath.contains(new File(innerUrl));
            }
            return false;
        }
    }
}

