/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.P2Client;
import dev.equo.solstice.p2.P2Query;
import dev.equo.solstice.p2.P2Unit;
import dev.equo.solstice.p2.Unchecked;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class P2Session {
    final List<P2Unit> units = new ArrayList<P2Unit>();
    private final Map<String, Map<String, RequirementRoot>> requirements = new HashMap<String, Map<String, RequirementRoot>>();
    private final Map<String, FilterImpl> filterCache = new HashMap<String, FilterImpl>();

    public void populateFrom(P2Client client, String url) throws Exception {
        client.addUnits(this, url);
        this.sort();
    }

    private void sort() {
        this.units.sort(Comparator.naturalOrder());
        for (Map<String, RequirementRoot> namespace : this.requirements.values()) {
            for (RequirementRoot requirement : namespace.values()) {
                requirement.sortProviders();
            }
        }
    }

    public P2Unit getUnitById(String id) {
        for (P2Unit unit : this.units) {
            if (!id.equals(unit.id)) continue;
            return unit;
        }
        throw new IllegalArgumentException("No such unit id " + id);
    }

    public P2Query query() {
        return new P2Query(this);
    }

    private RequirementRoot requires(String namespace, String name) {
        Map perName = this.requirements.computeIfAbsent(namespace, unused -> new HashMap());
        return perName.computeIfAbsent(name, n -> new RequirementRoot(namespace, (String)n));
    }

    Requirement requires(String namespace, String name, boolean optional, @Nullable FilterImpl filter) {
        RequirementRoot root = this.requires(namespace, name);
        if (!optional && filter == null) {
            return root;
        }
        return new RequirementModified(root, optional, (Filter)filter);
    }

    void provides(String namespace, String name, P2Unit unit) {
        this.requires(namespace, name).add(unit);
    }

    FilterImpl parseFilter(String filter) {
        return this.filterCache.computeIfAbsent(filter, f -> {
            try {
                return FilterImpl.newInstance((String)f);
            }
            catch (InvalidSyntaxException e) {
                throw Unchecked.wrap((Exception)((Object)e));
            }
        });
    }

    private static class RequirementRoot
    implements Requirement {
        private final String namespace;
        private final String name;
        private Object providers;

        private RequirementRoot(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        @Nullable
        public Filter getFilter() {
            return null;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private void add(P2Unit unit) {
            this.providers = RequirementRoot.add(this.providers, unit);
        }

        @Override
        public boolean hasOnlyOneProvider() {
            return this.providers instanceof P2Unit;
        }

        @Override
        public P2Unit getOnlyProvider() {
            return (P2Unit)this.providers;
        }

        @Override
        public List<P2Unit> getProviders() {
            return RequirementRoot.get(this.providers);
        }

        @Override
        public Requirement getRoot() {
            return this;
        }

        private void sortProviders() {
            if (this.providers instanceof ArrayList) {
                ((ArrayList)this.providers).sort(Comparator.naturalOrder());
            }
        }

        private static Object add(Object existing, P2Unit toAdd) {
            if (existing == null) {
                return toAdd;
            }
            if (existing instanceof P2Unit) {
                ArrayList<P2Unit> list = new ArrayList<P2Unit>();
                list.add((P2Unit)existing);
                list.add(toAdd);
                return list;
            }
            ((ArrayList)existing).add(toAdd);
            return existing;
        }

        private static List<P2Unit> get(Object existing) {
            if (existing == null) {
                return Collections.emptyList();
            }
            if (existing instanceof P2Unit) {
                return Collections.singletonList((P2Unit)existing);
            }
            return (ArrayList)existing;
        }

        public String toString() {
            if (this.namespace.equals("java.package")) {
                return "pkg " + this.name;
            }
            if (this.namespace.equals("osgi.bundle")) {
                return "bundle " + this.name;
            }
            if (this.namespace.equals("org.eclipse.equinox.p2.iu")) {
                return "iu " + this.name;
            }
            return this.namespace + " " + this.name;
        }
    }

    private static class RequirementModified
    implements Requirement {
        final RequirementRoot root;
        final boolean isOptional;
        @Nullable
        final Filter filter;

        RequirementModified(RequirementRoot root, boolean isOptional, @Nullable Filter filter) {
            this.root = root;
            this.isOptional = isOptional;
            this.filter = filter;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }

        @Override
        @Nullable
        public Filter getFilter() {
            return this.filter;
        }

        public String toString() {
            if (this.isOptional) {
                if (this.filter != null) {
                    return this.root + " (opt) " + this.filter;
                }
                return this.root + " (opt)";
            }
            return this.root + " " + this.filter;
        }

        @Override
        public String getNamespace() {
            return this.root.getNamespace();
        }

        @Override
        public String getName() {
            return this.root.getName();
        }

        @Override
        public boolean hasOnlyOneProvider() {
            return this.root.hasOnlyOneProvider();
        }

        @Override
        public P2Unit getOnlyProvider() {
            return this.root.getOnlyProvider();
        }

        @Override
        public List<P2Unit> getProviders() {
            return this.root.getProviders();
        }

        @Override
        public Requirement getRoot() {
            return this.root;
        }
    }

    public static interface Requirement
    extends Comparable<Requirement> {
        public boolean isOptional();

        @Nullable
        public Filter getFilter();

        public String getNamespace();

        public String getName();

        public boolean hasOnlyOneProvider();

        public P2Unit getOnlyProvider();

        public List<P2Unit> getProviders();

        public Requirement getRoot();

        @Override
        default public int compareTo(@NotNull Requirement o) {
            int byNamespace = this.getNamespace().compareTo(o.getNamespace());
            if (byNamespace != 0) {
                return byNamespace;
            }
            int byName = this.getName().compareTo(o.getName());
            if (byName != 0) {
                return byName;
            }
            return this.toString().compareTo(o.toString());
        }
    }
}

