package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMetricsListBuilder extends PodMetricsListFluentImpl<PodMetricsListBuilder> implements VisitableBuilder<PodMetricsList,PodMetricsListBuilder> {

    PodMetricsListFluent<?> fluent;
    Boolean validationEnabled;

    public PodMetricsListBuilder() {
        this(true);
    }

    public PodMetricsListBuilder(Boolean validationEnabled) {
        this(new PodMetricsList(), validationEnabled);
    }

    public PodMetricsListBuilder(PodMetricsListFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMetricsListBuilder(PodMetricsListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodMetricsList(), validationEnabled);
    }

    public PodMetricsListBuilder(PodMetricsListFluent<?> fluent,PodMetricsList instance) {
        this(fluent, instance, true);
    }

    public PodMetricsListBuilder(PodMetricsListFluent<?> fluent,PodMetricsList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMetricsListBuilder(PodMetricsList instance) {
        this(instance,true);
    }

    public PodMetricsListBuilder(PodMetricsList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMetricsList build() {
        PodMetricsList buildable = new PodMetricsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMetricsListBuilder that = (PodMetricsListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
