package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentStatusBuilder extends VolumeAttachmentStatusFluentImpl<VolumeAttachmentStatusBuilder> implements VisitableBuilder<VolumeAttachmentStatus,VolumeAttachmentStatusBuilder> {

    VolumeAttachmentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeAttachmentStatusBuilder() {
        this(true);
    }

    public VolumeAttachmentStatusBuilder(Boolean validationEnabled) {
        this(new VolumeAttachmentStatus(), validationEnabled);
    }

    public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new VolumeAttachmentStatus(), validationEnabled);
    }

    public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,VolumeAttachmentStatus instance) {
        this(fluent, instance, true);
    }

    public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,VolumeAttachmentStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttachError(instance.getAttachError()); 
        fluent.withAttached(instance.getAttached()); 
        fluent.withAttachmentMetadata(instance.getAttachmentMetadata()); 
        fluent.withDetachError(instance.getDetachError()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentStatusBuilder(VolumeAttachmentStatus instance) {
        this(instance,true);
    }

    public VolumeAttachmentStatusBuilder(VolumeAttachmentStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttachError(instance.getAttachError()); 
        this.withAttached(instance.getAttached()); 
        this.withAttachmentMetadata(instance.getAttachmentMetadata()); 
        this.withDetachError(instance.getDetachError()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentStatus build() {
        VolumeAttachmentStatus buildable = new VolumeAttachmentStatus(fluent.getAttachError(),fluent.getAttached(),fluent.getAttachmentMetadata(),fluent.getDetachError());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeAttachmentStatusBuilder that = (VolumeAttachmentStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
