package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSIDriverBuilder extends CSIDriverFluentImpl<CSIDriverBuilder> implements VisitableBuilder<CSIDriver,CSIDriverBuilder> {

    CSIDriverFluent<?> fluent;
    Boolean validationEnabled;

    public CSIDriverBuilder() {
        this(true);
    }

    public CSIDriverBuilder(Boolean validationEnabled) {
        this(new CSIDriver(), validationEnabled);
    }

    public CSIDriverBuilder(CSIDriverFluent<?> fluent) {
        this(fluent, true);
    }

    public CSIDriverBuilder(CSIDriverFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CSIDriver(), validationEnabled);
    }

    public CSIDriverBuilder(CSIDriverFluent<?> fluent,CSIDriver instance) {
        this(fluent, instance, true);
    }

    public CSIDriverBuilder(CSIDriverFluent<?> fluent,CSIDriver instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriverBuilder(CSIDriver instance) {
        this(instance,true);
    }

    public CSIDriverBuilder(CSIDriver instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSIDriver build() {
        CSIDriver buildable = new CSIDriver(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSIDriverBuilder that = (CSIDriverBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
