/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.Hyphenator;
import com.openhtmltopdf.extend.impl.FSNoOpCacheStore;
import com.openhtmltopdf.outputdevice.helper.AddedFont;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.pdfboxout.PDFontSupplier;
import com.openhtmltopdf.pdfboxout.PageSupplier;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilderState;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.XRLog;
import java.awt.FontFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfRendererBuilder
extends BaseRendererBuilder<PdfRendererBuilder, PdfRendererBuilderState> {
    public PdfRendererBuilder() {
        super((BaseRendererBuilder.BaseRendererBuilderState)new PdfRendererBuilderState());
        for (CacheStore cacheStore : CacheStore.values()) {
            ((PdfRendererBuilderState)this.state)._caches.put(cacheStore, (FSCacheEx<String, FSCacheValue>)FSNoOpCacheStore.INSTANCE);
        }
    }

    public void run() throws IOException {
        try (Closeable d = this.applyDiagnosticConsumer();
             PdfBoxRenderer renderer = this.buildPdfRenderer(d);){
            renderer.createPDF();
        }
    }

    public PdfBoxRenderer buildPdfRenderer() {
        Closeable d = this.applyDiagnosticConsumer();
        try {
            return this.buildPdfRenderer(d);
        }
        catch (Throwable e) {
            OpenUtil.closeQuietly((Closeable)d);
            throw e;
        }
    }

    public PdfBoxRenderer buildPdfRenderer(Closeable diagnosticConsumer) {
        UnicodeImplementation unicode = new UnicodeImplementation(((PdfRendererBuilderState)this.state)._reorderer, ((PdfRendererBuilderState)this.state)._splitter, ((PdfRendererBuilderState)this.state)._lineBreaker, ((PdfRendererBuilderState)this.state)._unicodeToLowerTransformer, ((PdfRendererBuilderState)this.state)._unicodeToUpperTransformer, ((PdfRendererBuilderState)this.state)._unicodeToTitleTransformer, ((PdfRendererBuilderState)this.state)._textDirection, ((PdfRendererBuilderState)this.state)._charBreaker);
        PageDimensions pageSize = new PageDimensions(((PdfRendererBuilderState)this.state)._pageWidth, ((PdfRendererBuilderState)this.state)._pageHeight, ((PdfRendererBuilderState)this.state)._isPageSizeInches);
        BaseDocument doc = new BaseDocument(((PdfRendererBuilderState)this.state)._baseUri, ((PdfRendererBuilderState)this.state)._html, ((PdfRendererBuilderState)this.state)._document, ((PdfRendererBuilderState)this.state)._file, ((PdfRendererBuilderState)this.state)._uri);
        PdfBoxRenderer renderer = new PdfBoxRenderer(doc, unicode, pageSize, (PdfRendererBuilderState)this.state, diagnosticConsumer);
        try {
            PdfBoxFontResolver resolver = renderer.getFontResolver();
            for (AddedFont font : ((PdfRendererBuilderState)this.state)._fonts) {
                if (((PdfRendererBuilderState)this.state)._svgImpl != null && font.fontFile != null && font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.SVG)) {
                    try {
                        ((PdfRendererBuilderState)this.state)._svgImpl.addFontFile(font.fontFile, font.family, font.weight, font.style);
                    }
                    catch (FontFormatException | IOException e) {
                        XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.INIT_FONT_COULD_NOT_BE_LOADED, (Object)font.fontFile.getPath(), (Throwable)e);
                    }
                }
                if (((PdfRendererBuilderState)this.state)._mathmlImpl != null && font.fontFile != null && font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.MATHML)) {
                    try {
                        ((PdfRendererBuilderState)this.state)._mathmlImpl.addFontFile(font.fontFile, font.family, font.weight, font.style);
                    }
                    catch (FontFormatException | IOException e) {
                        XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.INIT_FONT_COULD_NOT_BE_LOADED, (Object)font.fontFile.getPath(), (Throwable)e);
                    }
                }
                if (!font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.DOCUMENT) && !font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.FALLBACK_PRE) && !font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.FALLBACK_FINAL)) continue;
                IdentValue fontStyle = null;
                if (font.style != null) {
                    switch (font.style) {
                        case NORMAL: {
                            fontStyle = IdentValue.NORMAL;
                            break;
                        }
                        case ITALIC: {
                            fontStyle = IdentValue.ITALIC;
                            break;
                        }
                        case OBLIQUE: {
                            fontStyle = IdentValue.OBLIQUE;
                            break;
                        }
                        default: {
                            fontStyle = null;
                        }
                    }
                }
                PdfBoxFontResolver.FontGroup group = font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.FALLBACK_PRE) ? PdfBoxFontResolver.FontGroup.PRE_BUILT_IN_FALLBACK : (font.usedFor.contains(BaseRendererBuilder.FSFontUseCase.FALLBACK_FINAL) ? PdfBoxFontResolver.FontGroup.FINAL_FALLBACK : PdfBoxFontResolver.FontGroup.MAIN);
                if (font.supplier != null) {
                    resolver.addFont((FSSupplier<InputStream>)font.supplier, font.family, font.weight, fontStyle, font.subset, group);
                    continue;
                }
                if (font.pdfontSupplier != null) {
                    resolver.addFont((PDFontSupplier)font.pdfontSupplier, font.family, font.weight, fontStyle, font.subset, group);
                    continue;
                }
                try {
                    resolver.addFont(font.fontFile, font.family, font.weight, fontStyle, font.subset, group);
                }
                catch (Exception e) {
                    XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.INIT_FONT_COULD_NOT_BE_LOADED, (Object)font.fontFile.getPath(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            OpenUtil.closeQuietly((Closeable)renderer);
            throw e;
        }
        return renderer;
    }

    public PdfRendererBuilder toStream(OutputStream out) {
        ((PdfRendererBuilderState)this.state)._os = out;
        return this;
    }

    public PdfRendererBuilder usePdfVersion(float version) {
        ((PdfRendererBuilderState)this.state)._pdfVersion = version;
        return this;
    }

    public PdfRendererBuilder usePdfAConformance(PdfAConformance pdfAConformance) {
        ((PdfRendererBuilderState)this.state)._pdfAConformance = pdfAConformance;
        if (pdfAConformance.getPdfVersion() != 0.0f) {
            ((PdfRendererBuilderState)this.state)._pdfVersion = pdfAConformance.getPdfVersion();
        }
        return this;
    }

    @Deprecated
    public PdfRendererBuilder usePdfUaAccessbility(boolean pdfUaAccessibility) {
        return this.usePdfUaAccessibility(pdfUaAccessibility);
    }

    public PdfRendererBuilder usePdfUaAccessibility(boolean pdfUaAccessibility) {
        ((PdfRendererBuilderState)this.state)._pdfUaConform = pdfUaAccessibility;
        return this;
    }

    public PdfRendererBuilder useColorProfile(byte[] colorProfile) {
        ((PdfRendererBuilderState)this.state)._colorProfile = colorProfile;
        return this;
    }

    public PdfRendererBuilder usePDDocument(PDDocument doc) {
        ((PdfRendererBuilderState)this.state).pddocument = doc;
        return this;
    }

    public PdfRendererBuilder useFont(PDFontSupplier supplier, String fontFamily, Integer fontWeight, BaseRendererBuilder.FontStyle fontStyle, boolean subset) {
        ((PdfRendererBuilderState)this.state)._fonts.add(new AddedFont((Object)supplier, fontWeight, fontFamily, subset, fontStyle, EnumSet.of(BaseRendererBuilder.FSFontUseCase.DOCUMENT)));
        return this;
    }

    public PdfRendererBuilder useFont(PDFontSupplier supplier, String fontFamily) {
        return this.useFont(supplier, fontFamily, 400, BaseRendererBuilder.FontStyle.NORMAL, true);
    }

    public PdfRendererBuilder withProducer(String producer) {
        ((PdfRendererBuilderState)this.state)._producer = producer;
        return this;
    }

    public PdfRendererBuilder useHyphenation(Hyphenator hyphenator) {
        ((PdfRendererBuilderState)this.state)._hyphenator = hyphenator;
        return this;
    }

    public PdfRendererBuilder useCacheStore(CacheStore which, FSCacheEx<String, FSCacheValue> cache) {
        ((PdfRendererBuilderState)this.state)._caches.put(which, cache);
        return this;
    }

    public PdfRendererBuilder usePageSupplier(PageSupplier pageSupplier) {
        ((PdfRendererBuilderState)this.state)._pageSupplier = pageSupplier;
        return this;
    }

    public static enum PdfAConformance {
        NONE(-1, "", 0.0f),
        PDFA_1_A(1, "A", 1.4f),
        PDFA_1_B(1, "B", 1.4f),
        PDFA_2_A(2, "A", 1.7f),
        PDFA_2_B(2, "B", 1.7f),
        PDFA_2_U(2, "U", 1.7f),
        PDFA_3_A(3, "A", 1.7f),
        PDFA_3_B(3, "B", 1.7f),
        PDFA_3_U(3, "U", 1.7f);

        private final int part;
        private final String value;
        private final float pdfVersion;

        private PdfAConformance(int part, String value, float pdfVersion) {
            this.part = part;
            this.value = value;
            this.pdfVersion = pdfVersion;
        }

        public String getConformanceValue() {
            return this.value;
        }

        public int getPart() {
            return this.part;
        }

        public float getPdfVersion() {
            return this.pdfVersion;
        }
    }

    public static enum CacheStore {
        PDF_FONT_METRICS;

    }
}

