/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

import brave.propagation.TraceContext;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.brave.bridge.BraveTraceContext;
import io.micrometer.tracing.internal.EncodingUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class LinkUtils {
    private static final String LINKS_PREFIX = "links[";
    private static final String TRACE_ID = "links[%s].traceId";
    private static final String SPAN_ID = "links[%s].spanId";
    private static final String TAG = "links[%s].tags[%s]";
    private static final Pattern LINKS_ID = Pattern.compile("^links\\[(.*)]\\..*$");
    private static final Pattern TAG_KEY = Pattern.compile("^links\\[.*]\\.tags\\[(.*)]$");

    LinkUtils() {
    }

    static boolean isApplicable(Map.Entry<String, String> entry) {
        return entry.getKey().startsWith(LINKS_PREFIX);
    }

    static int linkGroup(Map.Entry<String, String> entry) {
        Matcher matcher = LINKS_ID.matcher(entry.getKey());
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    static String traceIdKey(long index) {
        return String.format(TRACE_ID, index);
    }

    static String spanIdKey(long index) {
        return String.format(SPAN_ID, index);
    }

    static String tagKey(long index, String tagKey) {
        return String.format(TAG, index, tagKey);
    }

    static int nextIndex(Map<String, String> tags) {
        return tags.entrySet().stream().filter(LinkUtils::isApplicable).collect(Collectors.groupingBy(LinkUtils::linkGroup)).keySet().size();
    }

    @Nullable
    static Link toLink(List<Map.Entry<String, String>> groupedTags) {
        String traceId = "";
        String spanId = "";
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry<String, String> groupedTag : groupedTags) {
            String tagKey;
            if (groupedTag.getKey().endsWith(".traceId")) {
                traceId = groupedTag.getValue();
                continue;
            }
            if (groupedTag.getKey().endsWith(".spanId")) {
                spanId = groupedTag.getValue();
                continue;
            }
            if (!groupedTag.getKey().contains("tags") || (tagKey = LinkUtils.tagKeyNameFromString(groupedTag.getKey())) == null) continue;
            tags.put(tagKey, groupedTag.getValue());
        }
        if (StringUtils.isNotBlank((String)traceId)) {
            TraceContext.Builder newBuilder = LinkUtils.traceId(brave.propagation.TraceContext.newBuilder(), traceId);
            BraveTraceContext traceContext = new BraveTraceContext(newBuilder.spanId(LinkUtils.spanId(spanId)).build());
            return new Link((TraceContext)traceContext, tags);
        }
        return null;
    }

    static TraceContext.Builder traceId(TraceContext.Builder delegate, String traceId) {
        long[] fromString = EncodingUtils.fromString((CharSequence)traceId);
        if (fromString.length == 2) {
            delegate.traceIdHigh(fromString[0]);
            delegate.traceId(fromString[1]);
        } else {
            delegate.traceId(fromString[0]);
        }
        return delegate;
    }

    static long spanId(String spanId) {
        long[] fromString;
        return fromString[(fromString = EncodingUtils.fromString((CharSequence)spanId)).length == 2 ? 1 : 0];
    }

    @Nullable
    static String tagKeyNameFromString(String tag) {
        Matcher matcher = TAG_KEY.matcher(tag);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

