/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.appender.v2_17;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.LogEventToReplay;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.ContextDataAccessor;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.LogEventMapper;
import io.opentelemetry.instrumentation.log4j.contextdata.v2_17.internal.ContextDataKeys;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="OpenTelemetry", category="Core", elementType="appender")
public class OpenTelemetryAppender
extends AbstractAppender {
    static final String PLUGIN_NAME = "OpenTelemetry";
    private final LogEventMapper<ReadOnlyStringMap> mapper;
    private volatile OpenTelemetry openTelemetry;
    private final BlockingQueue<LogEventToReplay> eventsToReplay;
    private final AtomicBoolean replayLimitWarningLogged = new AtomicBoolean();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static void install(OpenTelemetry openTelemetry) {
        org.apache.logging.log4j.spi.LoggerContext loggerContextSpi = LogManager.getContext((boolean)false);
        if (!(loggerContextSpi instanceof LoggerContext)) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)loggerContextSpi;
        Configuration config = loggerContext.getConfiguration();
        config.getAppenders().values().forEach(appender -> {
            if (appender instanceof OpenTelemetryAppender) {
                ((OpenTelemetryAppender)((Object)appender)).setOpenTelemetry(openTelemetry);
            }
        });
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B builder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private OpenTelemetryAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, Property[] properties, boolean captureExperimentalAttributes, boolean captureMapMessageAttributes, boolean captureMarkerAttribute, String captureContextDataAttributes, int numLogsCapturedBeforeOtelInstall, OpenTelemetry openTelemetry) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.mapper = new LogEventMapper<ReadOnlyStringMap>(ContextDataAccessorImpl.INSTANCE, captureExperimentalAttributes, captureMapMessageAttributes, captureMarkerAttribute, OpenTelemetryAppender.splitAndFilterBlanksAndNulls(captureContextDataAttributes));
        this.openTelemetry = openTelemetry;
        this.eventsToReplay = numLogsCapturedBeforeOtelInstall != 0 ? new ArrayBlockingQueue<LogEventToReplay>(numLogsCapturedBeforeOtelInstall) : new ArrayBlockingQueue<LogEventToReplay>(1000);
    }

    private static List<String> splitAndFilterBlanksAndNulls(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpenTelemetry(OpenTelemetry openTelemetry) {
        ArrayList eventsToReplay = new ArrayList();
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.openTelemetry = openTelemetry;
            this.eventsToReplay.drainTo(eventsToReplay);
        }
        finally {
            writeLock.unlock();
        }
        for (LogEventToReplay eventToReplay : eventsToReplay) {
            this.emit(openTelemetry, eventToReplay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        OpenTelemetry openTelemetry = this.openTelemetry;
        if (openTelemetry != null) {
            this.emit(openTelemetry, event);
            return;
        }
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            openTelemetry = this.openTelemetry;
            if (openTelemetry != null) {
                this.emit(openTelemetry, event);
                return;
            }
            LogEventToReplay logEventToReplay = new LogEventToReplay(event);
            if (!this.eventsToReplay.offer(logEventToReplay) && !this.replayLimitWarningLogged.getAndSet(true)) {
                String message = "numLogsCapturedBeforeOtelInstall value of the OpenTelemetry appender is too small.";
                System.err.println(message);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void emit(OpenTelemetry openTelemetry, LogEvent event) {
        String instrumentationName = event.getLoggerName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogRecordBuilder builder = openTelemetry.getLogsBridge().loggerBuilder(instrumentationName).build().logRecordBuilder();
        ReadOnlyStringMap contextData = event.getContextData();
        Context context = Context.current();
        if (context == Context.root()) {
            ContextDataAccessorImpl contextDataAccessor = ContextDataAccessorImpl.INSTANCE;
            String traceId = contextDataAccessor.getValue(contextData, ContextDataKeys.TRACE_ID_KEY);
            String spanId = contextDataAccessor.getValue(contextData, ContextDataKeys.SPAN_ID_KEY);
            String traceFlags = contextDataAccessor.getValue(contextData, ContextDataKeys.TRACE_FLAGS_KEY);
            if (traceId != null && spanId != null && traceFlags != null) {
                context = Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)SpanContext.create((String)traceId, (String)spanId, (TraceFlags)TraceFlags.fromHex((CharSequence)traceFlags, (int)0), (TraceState)TraceState.getDefault())));
            }
        }
        this.mapper.mapLogEvent(builder, event.getMessage(), event.getLevel(), event.getMarker(), event.getThrown(), contextData, event.getThreadName(), event.getThreadId(), context);
        Instant timestamp = event.getInstant();
        if (timestamp != null) {
            builder.setTimestamp(TimeUnit.MILLISECONDS.toNanos(timestamp.getEpochMillisecond()) + (long)timestamp.getNanoOfMillisecond(), TimeUnit.NANOSECONDS);
        }
        builder.emit();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<OpenTelemetryAppender> {
        @PluginBuilderAttribute
        private boolean captureExperimentalAttributes;
        @PluginBuilderAttribute
        private boolean captureMapMessageAttributes;
        @PluginBuilderAttribute
        private boolean captureMarkerAttribute;
        @PluginBuilderAttribute
        private String captureContextDataAttributes;
        @PluginBuilderAttribute
        private int numLogsCapturedBeforeOtelInstall;
        @Nullable
        private OpenTelemetry openTelemetry;

        @CanIgnoreReturnValue
        public B setCaptureExperimentalAttributes(boolean captureExperimentalAttributes) {
            this.captureExperimentalAttributes = captureExperimentalAttributes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        @CanIgnoreReturnValue
        public B setCaptureMapMessageAttributes(boolean captureMapMessageAttributes) {
            this.captureMapMessageAttributes = captureMapMessageAttributes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        @CanIgnoreReturnValue
        public B setCaptureMarkerAttribute(boolean captureMarkerAttribute) {
            this.captureMarkerAttribute = captureMarkerAttribute;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        @CanIgnoreReturnValue
        public B setCaptureContextDataAttributes(String captureContextDataAttributes) {
            this.captureContextDataAttributes = captureContextDataAttributes;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        @CanIgnoreReturnValue
        public B setNumLogsCapturedBeforeOtelInstall(int numLogsCapturedBeforeOtelInstall) {
            this.numLogsCapturedBeforeOtelInstall = numLogsCapturedBeforeOtelInstall;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        @CanIgnoreReturnValue
        public B setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public OpenTelemetryAppender build() {
            OpenTelemetry openTelemetry = this.openTelemetry;
            return new OpenTelemetryAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray(), this.captureExperimentalAttributes, this.captureMapMessageAttributes, this.captureMarkerAttribute, this.captureContextDataAttributes, this.numLogsCapturedBeforeOtelInstall, openTelemetry);
        }
    }

    private static enum ContextDataAccessorImpl implements ContextDataAccessor<ReadOnlyStringMap>
    {
        INSTANCE;


        @Override
        @Nullable
        public String getValue(ReadOnlyStringMap contextData, String key) {
            return (String)contextData.getValue(key);
        }

        @Override
        public void forEach(ReadOnlyStringMap contextData, BiConsumer<String, String> action) {
            contextData.forEach(action::accept);
        }
    }
}

