/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.propagation.TextMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;

public class JmsTextMapInjectAdapter
implements TextMap {
    static final String DASH = "_$dash$_";
    private final Message message;

    public JmsTextMapInjectAdapter(Message message) {
        this.message = message;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("iterator should never be used with Tracer.inject()");
    }

    public void put(String key, String value) {
        if (this.message == null) {
            return;
        }
        try {
            this.message.setStringProperty(this.encodeDash(key), value);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeDash(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        return key.replace("-", DASH);
    }
}

