/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.rpc.core;

import io.seata.common.util.CollectionUtils;
import java.util.Map;

public interface BaseRpcFilter<T> {
    public static final String[] TRX_CONTEXT_KEYS = new String[]{"TX_XID", "TX_BRANCH_TYPE"};

    default public String getValueFromMap(Map<String, String> rpcContextMap, String key) {
        return rpcContextMap.get(key);
    }

    default public void assertNotNull(Object obj, String errMsg) {
        if (obj == null) {
            throw new IllegalStateException(errMsg);
        }
    }

    default public String getJsonContext(Map<String, String> contextMap) {
        if (CollectionUtils.isEmpty(contextMap)) {
            return "";
        }
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
            String contextValue = contextMap.get(TRX_CONTEXT_KEYS[i]);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(TRX_CONTEXT_KEYS[i]).append("\"");
            sb.append(":");
            if (null == contextValue) {
                sb.append("null");
                continue;
            }
            sb.append("\"").append(contextValue).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

