/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.tx.api.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.integration.tx.api.remoting.RemotingDesc;
import io.seata.integration.tx.api.remoting.RemotingParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultRemotingParser {
    protected static List<RemotingParser> allRemotingParsers = new ArrayList<RemotingParser>();
    protected static Map<Object, RemotingDesc> remotingServiceMap = new ConcurrentHashMap<Object, RemotingDesc>();

    public static DefaultRemotingParser get() {
        return SingletonHolder.INSTANCE;
    }

    protected DefaultRemotingParser() {
        this.initRemotingParser();
    }

    protected void initRemotingParser() {
        List<RemotingParser> remotingParsers = EnhancedServiceLoader.loadAll(RemotingParser.class);
        if (CollectionUtils.isNotEmpty(remotingParsers)) {
            allRemotingParsers.addAll(remotingParsers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerRemotingParser(RemotingParser remotingParser) {
        DefaultRemotingParser defaultRemotingParser = this;
        synchronized (defaultRemotingParser) {
            return allRemotingParsers.add(remotingParser);
        }
    }

    public RemotingParser isRemoting(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isRemoting(bean, beanName)) continue;
            return remotingParser;
        }
        return null;
    }

    public boolean isReference(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isReference(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public boolean isService(Object bean, String beanName) {
        for (RemotingParser remotingParser : allRemotingParsers) {
            if (!remotingParser.isService(bean, beanName)) continue;
            return true;
        }
        return false;
    }

    public RemotingDesc getServiceDesc(Object bean, String beanName) {
        ArrayList<RemotingDesc> ret = new ArrayList<RemotingDesc>();
        for (RemotingParser remotingParser : allRemotingParsers) {
            RemotingDesc s = remotingParser.getServiceDesc(bean, beanName);
            if (s == null) continue;
            ret.add(s);
        }
        if (ret.size() == 1) {
            return (RemotingDesc)ret.get(0);
        }
        if (ret.size() > 1) {
            throw new FrameworkException(String.format("More than one RemotingParser for bean: %s", beanName));
        }
        return null;
    }

    public RemotingDesc parserRemotingServiceInfo(Object bean, String beanName, RemotingParser remotingParser) {
        if (remotingServiceMap.containsKey(bean)) {
            return remotingServiceMap.get(bean);
        }
        RemotingDesc remotingBeanDesc = remotingParser.getServiceDesc(bean, beanName);
        if (remotingBeanDesc == null) {
            return null;
        }
        remotingServiceMap.put(bean, remotingBeanDesc);
        if (remotingParser.isReference(bean, beanName)) {
            remotingBeanDesc.setReference(true);
        }
        return remotingBeanDesc;
    }

    public RemotingDesc getRemotingBeanDesc(Object bean) {
        return remotingServiceMap.get(bean);
    }

    private static class SingletonHolder {
        private static final DefaultRemotingParser INSTANCE = new DefaultRemotingParser();

        private SingletonHolder() {
        }
    }
}

