/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.interceptor.parser;

import io.seata.common.util.ReflectionUtil;
import io.seata.integration.tx.api.interceptor.TxBeanParserUtils;
import io.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import io.seata.integration.tx.api.interceptor.parser.DefaultResourceRegisterParser;
import io.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import io.seata.integration.tx.api.remoting.RemotingDesc;
import io.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.TccActionInterceptorHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TccActionInterceptorParser
implements InterfaceParser {
    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) {
        RemotingDesc remotingDesc;
        boolean isTxRemotingBean = TxBeanParserUtils.isTxRemotingBean(target, objectName);
        if (isTxRemotingBean && (remotingDesc = DefaultRemotingParser.get().getRemotingBeanDesc(target)) != null) {
            if (remotingDesc.isService()) {
                DefaultResourceRegisterParser.get().registerResource(target, objectName);
            }
            if (remotingDesc.isReference()) {
                Set<String> methodsToProxy = this.tccProxyTargetMethod(remotingDesc);
                if (remotingDesc != null && !methodsToProxy.isEmpty()) {
                    TccActionInterceptorHandler proxyInvocationHandler = new TccActionInterceptorHandler(remotingDesc, methodsToProxy);
                    return proxyInvocationHandler;
                }
            }
        }
        return null;
    }

    private Set<String> tccProxyTargetMethod(RemotingDesc remotingDesc) {
        if (!remotingDesc.isReference() || remotingDesc == null) {
            return Collections.emptySet();
        }
        HashSet<String> methodsToProxy = new HashSet<String>();
        Class<?> tccServiceClazz = remotingDesc.getServiceClass();
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(tccServiceClazz.getMethods()));
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(tccServiceClazz);
        if (interfaceClasses != null) {
            for (Class<?> interClass : interfaceClasses) {
                methods.addAll(Arrays.asList(interClass.getMethods()));
            }
        }
        for (Method method : methods) {
            TwoPhaseBusinessAction twoPhaseBusinessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
            if (twoPhaseBusinessAction == null) continue;
            methodsToProxy.add(method.getName());
        }
        if (methodsToProxy.isEmpty()) {
            return Collections.emptySet();
        }
        return methodsToProxy;
    }
}

