/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.seata.common.loader.LoadLevel;
import io.seata.saga.statelang.parser.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@LoadLevel(name="jackson")
public class JacksonJsonParser
implements JsonParser {
    private final ObjectMapper objectMapperWithAutoType = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping.NON_FINAL, "@type").enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER}).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disableDefaultTyping().enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER}).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    public static final String NAME = "jackson";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toJsonString(Object o, boolean prettyPrint) {
        return this.toJsonString(o, false, prettyPrint);
    }

    @Override
    public boolean useAutoType(String json) {
        return json != null && json.contains("\"@type\"");
    }

    @Override
    public String toJsonString(Object o, boolean ignoreAutoType, boolean prettyPrint) {
        try {
            if (o instanceof List && ((List)o).isEmpty()) {
                return "[]";
            }
            if (prettyPrint) {
                if (ignoreAutoType) {
                    return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
                }
                return this.objectMapperWithAutoType.writerWithDefaultPrettyPrinter().writeValueAsString(o);
            }
            if (ignoreAutoType) {
                return this.objectMapper.writeValueAsString(o);
            }
            return this.objectMapperWithAutoType.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Parse object to json error", e);
        }
    }

    @Override
    public <T> T parse(String json, Class<T> type, boolean ignoreAutoType) {
        try {
            if ("[]".equals(json)) {
                return (T)new ArrayList(0);
            }
            if (ignoreAutoType) {
                return (T)this.objectMapper.readValue(json, type);
            }
            return (T)this.objectMapperWithAutoType.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Parse json to object error", e);
        }
    }
}

