/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import io.seata.common.XID;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.NetUtil;
import io.seata.core.rpc.Disposable;
import io.seata.core.rpc.RemotingServer;
import io.seata.core.rpc.ShutdownHook;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.NettyRemotingServer;
import io.seata.core.rpc.netty.NettyServerConfig;
import io.seata.server.ParameterParser;
import io.seata.server.UUIDGenerator;
import io.seata.server.coordinator.DefaultCoordinator;
import io.seata.server.env.ContainerHelper;
import io.seata.server.env.PortHelper;
import io.seata.server.metrics.MetricsManager;
import io.seata.server.session.SessionHolder;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    public static void main(String[] args) throws IOException {
        int port = PortHelper.getPort(args);
        System.setProperty("server.port", Integer.toString(port));
        Logger logger = LoggerFactory.getLogger(Server.class);
        if (ContainerHelper.isRunningInContainer()) {
            logger.info("The server is running in container.");
        }
        ParameterParser parameterParser = new ParameterParser(args);
        MetricsManager.get().init();
        System.setProperty("store.mode", parameterParser.getStoreMode());
        ThreadPoolExecutor workingThreads = new ThreadPoolExecutor(NettyServerConfig.getMinServerPoolSize(), NettyServerConfig.getMaxServerPoolSize(), NettyServerConfig.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(NettyServerConfig.getMaxTaskQueueSize()), (ThreadFactory)new NamedThreadFactory("ServerHandlerThread", NettyServerConfig.getMaxServerPoolSize()), new ThreadPoolExecutor.CallerRunsPolicy());
        NettyRemotingServer nettyRemotingServer = new NettyRemotingServer(workingThreads);
        nettyRemotingServer.setListenPort(parameterParser.getPort());
        UUIDGenerator.init(parameterParser.getServerNode());
        SessionHolder.init(parameterParser.getStoreMode());
        DefaultCoordinator coordinator = new DefaultCoordinator((RemotingServer)nettyRemotingServer);
        coordinator.init();
        nettyRemotingServer.setHandler((TransactionMessageHandler)coordinator);
        ShutdownHook.getInstance().addDisposable((Disposable)coordinator);
        ShutdownHook.getInstance().addDisposable((Disposable)nettyRemotingServer);
        if (NetUtil.isValidIp((String)parameterParser.getHost(), (boolean)false)) {
            XID.setIpAddress((String)parameterParser.getHost());
        } else {
            XID.setIpAddress((String)NetUtil.getLocalIp());
        }
        XID.setPort((int)nettyRemotingServer.getListenPort());
        try {
            nettyRemotingServer.init();
        }
        catch (Throwable e) {
            logger.error("nettyServer init error:{}", (Object)e.getMessage(), (Object)e);
            System.exit(-1);
        }
        System.exit(0);
    }
}

