/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.env;

import io.seata.common.util.NumberUtils;
import io.seata.common.util.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class ContainerHelper {
    private static final String C_GROUP_PATH = "/proc/1/cgroup";
    private static final String DOCKER_PATH = "/docker";
    private static final String KUBEPODS_PATH = "/kubepods";
    private static final String ENV_SYSTEM_KEY = "SEATA_ENV";
    private static final String ENV_SEATA_IP_KEY = "SEATA_IP";
    private static final String ENV_SERVER_NODE_KEY = "SERVER_NODE";
    private static final String ENV_SEATA_PORT_KEY = "SEATA_PORT";
    private static final String ENV_STORE_MODE_KEY = "STORE_MODE";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunningInContainer() {
        Path path = Paths.get(C_GROUP_PATH, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) return false;
        try (Stream<String> stream = Files.lines(path);){
            boolean bl = stream.anyMatch(line -> line.contains(DOCKER_PATH) || line.contains(KUBEPODS_PATH));
            return bl;
        }
        catch (IOException e) {
            System.err.println("Judge if running in container failed: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public static String getEnv() {
        return StringUtils.trimToNull((String)System.getenv(ENV_SYSTEM_KEY));
    }

    public static String getHost() {
        return StringUtils.trimToNull((String)System.getenv(ENV_SEATA_IP_KEY));
    }

    public static int getPort() {
        return NumberUtils.toInt((String)System.getenv(ENV_SEATA_PORT_KEY), (int)8091);
    }

    public static Long getServerNode() {
        return NumberUtils.toLong((String)System.getenv(ENV_SERVER_NODE_KEY));
    }

    public static String getStoreMode() {
        return StringUtils.trimToNull((String)System.getenv(ENV_STORE_MODE_KEY));
    }
}

