/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.file;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.TransactionStoreManager;
import java.nio.ByteBuffer;

public class TransactionWriteStore
implements SessionStorable {
    private SessionStorable sessionRequest;
    private TransactionStoreManager.LogOperation operate;

    public TransactionWriteStore(SessionStorable sessionRequest, TransactionStoreManager.LogOperation operate) {
        this.sessionRequest = sessionRequest;
        this.operate = operate;
    }

    public TransactionWriteStore() {
    }

    public SessionStorable getSessionRequest() {
        return this.sessionRequest;
    }

    public void setSessionRequest(SessionStorable sessionRequest) {
        this.sessionRequest = sessionRequest;
    }

    public TransactionStoreManager.LogOperation getOperate() {
        return this.operate;
    }

    public void setOperate(TransactionStoreManager.LogOperation operate) {
        this.operate = operate;
    }

    @Override
    public byte[] encode() {
        byte[] bySessionRequest = this.sessionRequest.encode();
        byte byOpCode = this.getOperate().getCode();
        int len = bySessionRequest.length + 1;
        byte[] byResult = new byte[len];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byResult);
        byteBuffer.put(bySessionRequest);
        byteBuffer.put(byOpCode);
        return byResult;
    }

    @Override
    public void decode(byte[] src) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(src);
        byte[] bySessionRequest = new byte[src.length - 1];
        byteBuffer.get(bySessionRequest);
        byte byOpCode = byteBuffer.get();
        this.operate = TransactionStoreManager.LogOperation.getLogOperationByCode(byOpCode);
        SessionStorable tmpSessionStorable = this.getSessionInstanceByOperation(this.operate);
        tmpSessionStorable.decode(bySessionRequest);
        this.sessionRequest = tmpSessionStorable;
    }

    private SessionStorable getSessionInstanceByOperation(TransactionStoreManager.LogOperation logOperation) {
        SessionStorable sessionStorable = null;
        switch (logOperation) {
            case GLOBAL_ADD: 
            case GLOBAL_UPDATE: 
            case GLOBAL_REMOVE: {
                sessionStorable = new GlobalSession();
                break;
            }
            case BRANCH_ADD: 
            case BRANCH_UPDATE: 
            case BRANCH_REMOVE: {
                sessionStorable = new BranchSession();
                break;
            }
            default: {
                throw new ShouldNeverHappenException("incorrect logOperation");
            }
        }
        return sessionStorable;
    }
}

