/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.lock;

import com.google.common.collect.Lists;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.LambdaUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.lock.AbstractLocker;
import io.seata.core.lock.RowLock;
import io.seata.core.store.LockDO;
import io.seata.server.storage.redis.JedisPooledFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class RedisLocker
extends AbstractLocker {
    private static final Integer SUCCEED = 1;
    private static final Integer FAILED = 0;
    private static final String DEFAULT_REDIS_SEATA_ROW_LOCK_PREFIX = "SEATA_ROW_LOCK_";
    private static final String DEFAULT_REDIS_SEATA_GLOBAL_LOCK_PREFIX = "SEATA_GLOBAL_LOCK";
    private static final String XID = "xid";
    private static final String TRANSACTION_ID = "transactionId";
    private static final String BRANCH_ID = "branchId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String TABLE_NAME = "tableName";
    private static final String PK = "pk";
    private static final String ROW_KEY = "rowKey";

    public boolean acquireLock(List<RowLock> rowLocks) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        String needLockXid = rowLocks.get(0).getXid();
        Long branchId = rowLocks.get(0).getBranchId();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            int i;
            int i2;
            List<LockDO> needLockDOS = this.convertToLockDO(rowLocks);
            if (needLockDOS.size() > 1) {
                needLockDOS = needLockDOS.stream().filter(LambdaUtils.distinctByKey(LockDO::getRowKey)).collect(Collectors.toList());
            }
            ArrayList needLockKeys = new ArrayList();
            needLockDOS.forEach(lockDO -> needLockKeys.add(this.buildLockKey(lockDO.getRowKey())));
            Pipeline pipeline1 = jedis.pipelined();
            needLockKeys.stream().forEachOrdered(needLockKey -> pipeline1.hget(needLockKey, XID));
            List existedLockInfos = pipeline1.syncAndReturnAll();
            HashMap<Object, Object> needAddLock = new HashMap<Object, Object>(needLockKeys.size(), 1.0f);
            for (i2 = 0; i2 < needLockKeys.size(); ++i2) {
                String existedLockXid = (String)existedLockInfos.get(i2);
                if (StringUtils.isEmpty((CharSequence)existedLockXid)) {
                    needAddLock.put(needLockKeys.get(i2), needLockDOS.get(i2));
                    continue;
                }
                if (StringUtils.equals((String)existedLockXid, (String)needLockXid)) continue;
                boolean bl = false;
                return bl;
            }
            if (needAddLock.isEmpty()) {
                i2 = 1;
                return i2 != 0;
            }
            Pipeline pipeline = jedis.pipelined();
            ArrayList readyKeys = new ArrayList();
            needAddLock.forEach((key, value) -> {
                pipeline.hsetnx(key, XID, value.getXid());
                pipeline.hsetnx(key, TRANSACTION_ID, value.getTransactionId().toString());
                pipeline.hsetnx(key, BRANCH_ID, value.getBranchId().toString());
                pipeline.hset(key, ROW_KEY, value.getRowKey());
                pipeline.hset(key, RESOURCE_ID, value.getResourceId());
                pipeline.hset(key, TABLE_NAME, value.getTableName());
                pipeline.hset(key, PK, value.getPk());
                readyKeys.add(key);
            });
            List results = pipeline.syncAndReturnAll();
            List partitions = Lists.partition((List)results, (int)7);
            ArrayList success = new ArrayList(partitions.size());
            Integer status = SUCCEED;
            for (i = 0; i < partitions.size(); i += 1) {
                if (Objects.equals(((List)partitions.get(i)).get(0), FAILED)) {
                    status = FAILED;
                    continue;
                }
                success.add(readyKeys.get(i));
            }
            if (FAILED.equals(status)) {
                if (success.size() > 0) {
                    jedis.del(success.toArray(new String[0]));
                }
                i = 0;
                return i != 0;
            }
            String xidLockKey = this.buildXidLockKey(needLockXid);
            StringJoiner lockKeysString = new StringJoiner(";");
            needLockKeys.forEach(lockKeysString::add);
            jedis.hset(xidLockKey, branchId.toString(), lockKeysString.toString());
            boolean bl = true;
            return bl;
        }
    }

    public boolean releaseLock(List<RowLock> rowLocks) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        String currentXid = rowLocks.get(0).getXid();
        Long branchId = rowLocks.get(0).getBranchId();
        List needReleaseLocks = this.convertToLockDO(rowLocks);
        String[] needReleaseKeys = new String[needReleaseLocks.size()];
        for (int i = 0; i < needReleaseLocks.size(); ++i) {
            needReleaseKeys[i] = this.buildLockKey(((LockDO)needReleaseLocks.get(i)).getRowKey());
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Pipeline pipelined = jedis.pipelined();
            pipelined.del(needReleaseKeys);
            pipelined.hdel(this.buildXidLockKey(currentXid), new String[]{branchId.toString()});
            pipelined.sync();
            boolean bl = true;
            return bl;
        }
    }

    public boolean releaseLock(String xid, List<Long> branchIds) {
        if (CollectionUtils.isEmpty(branchIds)) {
            return true;
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xidLockKey = this.buildXidLockKey(xid);
            String[] branchIdsArray = new String[branchIds.size()];
            for (int i = 0; i < branchIds.size(); ++i) {
                branchIdsArray[i] = branchIds.get(i).toString();
            }
            List rowKeys = jedis.hmget(xidLockKey, branchIdsArray);
            if (CollectionUtils.isNotEmpty((Collection)rowKeys)) {
                Pipeline pipelined = jedis.pipelined();
                pipelined.hdel(xidLockKey, branchIdsArray);
                rowKeys.forEach(rowKeyStr -> {
                    if (StringUtils.isNotEmpty((CharSequence)rowKeyStr)) {
                        if (rowKeyStr.contains(";")) {
                            String[] keys = rowKeyStr.split(";");
                            pipelined.del(keys);
                        } else {
                            pipelined.del(rowKeyStr);
                        }
                    }
                });
                pipelined.sync();
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean releaseLock(String xid, Long branchId) {
        ArrayList<Long> branchIds = new ArrayList<Long>();
        branchIds.add(branchId);
        return this.releaseLock(xid, branchIds);
    }

    public boolean isLockable(List<RowLock> rowLocks) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            List locks = this.convertToLockDO(rowLocks);
            HashSet<String> lockKeys = new HashSet<String>();
            for (LockDO rowlock : locks) {
                lockKeys.add(this.buildLockKey(rowlock.getRowKey()));
            }
            String xid = rowLocks.get(0).getXid();
            Pipeline pipeline = jedis.pipelined();
            lockKeys.forEach(key -> pipeline.hget(key, XID));
            List existedXids = pipeline.syncAndReturnAll();
            boolean bl = existedXids.stream().allMatch(existedXid -> existedXid == null || xid.equals(existedXid));
            return bl;
        }
    }

    private String buildXidLockKey(String xid) {
        return DEFAULT_REDIS_SEATA_GLOBAL_LOCK_PREFIX + xid;
    }

    private String buildLockKey(String rowKey) {
        return DEFAULT_REDIS_SEATA_ROW_LOCK_PREFIX + rowKey;
    }
}

