/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.spring.annotation.GlobalTransactionScanner;
import io.seata.spring.annotation.datasource.SeataDataSourceBeanPostProcessor;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.spring.boot.autoconfigure.provider.SpringApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@ComponentScan(basePackages={"io.seata.spring.boot.autoconfigure.properties"})
@ConditionalOnProperty(prefix="seata", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
@EnableConfigurationProperties(value={SeataProperties.class})
public class SeataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    @Bean(value={"springApplicationContextProvider"})
    @ConditionalOnMissingBean(name={"springApplicationContextProvider"})
    public SpringApplicationContextProvider springApplicationContextProvider() {
        return new SpringApplicationContextProvider();
    }

    @Bean
    @DependsOn(value={"springApplicationContextProvider"})
    @ConditionalOnMissingBean(value={GlobalTransactionScanner.class})
    public GlobalTransactionScanner globalTransactionScanner(SeataProperties seataProperties) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        return new GlobalTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup());
    }

    @Bean(value={"seataDataSourceBeanPostProcessor"})
    @ConditionalOnProperty(prefix="seata", name={"enableAutoDataSourceProxy"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={SeataDataSourceBeanPostProcessor.class})
    public SeataDataSourceBeanPostProcessor seataDataSourceBeanPostProcessor(SeataProperties seataProperties) {
        return new SeataDataSourceBeanPostProcessor(seataProperties.isUseJdkProxy());
    }
}

