/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.provider;

import io.seata.common.holder.ObjectHolder;
import io.seata.config.Configuration;
import io.seata.config.ExtConfigurationProvider;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.context.ApplicationContext;

public class SpringBootConfigurationProvider
implements ExtConfigurationProvider {
    private static final String INTERCEPT_METHOD_PREFIX = "get";

    public Configuration provide(final Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(originalConfiguration.getClass(), (Callback)new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                if (method.getName().startsWith(SpringBootConfigurationProvider.INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                    Object result = null;
                    String rawDataId = (String)args[0];
                    if (args.length == 1) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId));
                    } else if (args.length == 2) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1]);
                    } else if (args.length == 3) {
                        result = SpringBootConfigurationProvider.this.get(SpringBootConfigurationProvider.this.convertDataId(rawDataId), args[1], (Long)args[2]);
                    }
                    if (null != result) {
                        if (method.getReturnType().equals(String.class)) {
                            return String.valueOf(result);
                        }
                        return result;
                    }
                }
                return method.invoke((Object)originalConfiguration, args);
            }
        });
    }

    private Object get(String dataId, Object defaultValue, long timeoutMills) throws IllegalAccessException {
        return this.get(dataId, defaultValue);
    }

    private Object get(String dataId, Object defaultValue) throws IllegalAccessException {
        Object result = this.get(dataId);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    private Object get(String dataId) throws IllegalAccessException {
        Object propertyObject;
        Optional<Field> fieldOptional;
        String propertySuffix = this.getPropertySuffix(dataId);
        Class propertyClass = this.getPropertyClass(this.getPropertyPrefix(dataId));
        if (null != propertyClass && (fieldOptional = Stream.of((propertyObject = ((ApplicationContext)ObjectHolder.INSTANCE.getObject(ApplicationContext.class)).getBean(propertyClass)).getClass().getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(propertySuffix)).findAny()).isPresent()) {
            Field field = fieldOptional.get();
            field.setAccessible(true);
            Object valueObject = field.get(propertyObject);
            if (valueObject instanceof Map) {
                String key = StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
                valueObject = ((Map)valueObject).get(key);
            }
            return valueObject;
        }
        return null;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.endsWith("grouplist")) {
            String suffix = StringUtils.removeEnd((String)rawDataId, (String)".grouplist");
            return "seata.service.grouplist." + suffix;
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "seata.service";
        }
        if (dataId.contains("grouplist")) {
            return "seata.service";
        }
        return StringUtils.substringBeforeLast((String)dataId, (String)String.valueOf('.'));
    }

    private String getPropertySuffix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "vgroupMapping";
        }
        if (dataId.contains("grouplist")) {
            return "grouplist";
        }
        return StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
    }

    private Class getPropertyClass(String propertyPrefix) {
        return StarterConstants.PROPERTY_MAP.entrySet().stream().filter(e -> propertyPrefix.equals(e.getKey())).findAny().map(Map.Entry::getValue).orElse(null);
    }
}

