/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.core.routing.type.complex;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.parsing.parser.sql.SQLStatement;
import io.shardingjdbc.core.routing.type.RoutingEngine;
import io.shardingjdbc.core.routing.type.RoutingResult;
import io.shardingjdbc.core.routing.type.complex.CartesianRoutingEngine;
import io.shardingjdbc.core.routing.type.simple.SimpleRoutingEngine;
import io.shardingjdbc.core.rule.BindingTableRule;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComplexRoutingEngine
implements RoutingEngine {
    private static final Logger log = LoggerFactory.getLogger(ComplexRoutingEngine.class);
    private final ShardingRule shardingRule;
    private final List<Object> parameters;
    private final Collection<String> logicTables;
    private final SQLStatement sqlStatement;

    @Override
    public RoutingResult route() {
        ArrayList<RoutingResult> result = new ArrayList<RoutingResult>(this.logicTables.size());
        TreeSet bindingTableNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (String each : this.logicTables) {
            Optional<BindingTableRule> bindingTableRule;
            Optional<TableRule> tableRule = this.shardingRule.tryFindTableRule(each);
            if (!tableRule.isPresent()) continue;
            if (!bindingTableNames.contains(each)) {
                result.add(new SimpleRoutingEngine(this.shardingRule, this.parameters, ((TableRule)tableRule.get()).getLogicTable(), this.sqlStatement).route());
            }
            if (!(bindingTableRule = this.shardingRule.findBindingTableRule(each)).isPresent()) continue;
            bindingTableNames.addAll(Lists.transform(((BindingTableRule)bindingTableRule.get()).getTableRules(), (Function)new Function<TableRule, String>(){

                public String apply(TableRule input) {
                    return input.getLogicTable();
                }
            }));
        }
        log.trace("mixed tables sharding result: {}", result);
        if (result.isEmpty()) {
            throw new ShardingJdbcException("Cannot find table rule and default data source with logic tables: '%s'", this.logicTables);
        }
        if (1 == result.size()) {
            return (RoutingResult)result.iterator().next();
        }
        return new CartesianRoutingEngine(result).route();
    }

    @ConstructorProperties(value={"shardingRule", "parameters", "logicTables", "sqlStatement"})
    public ComplexRoutingEngine(ShardingRule shardingRule, List<Object> parameters, Collection<String> logicTables, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.parameters = parameters;
        this.logicTables = logicTables;
        this.sqlStatement = sqlStatement;
    }
}

