/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeTarget;

public final class MethodParameterInfo
implements Declaration {
    private final MethodInfo method;
    private final short position;

    MethodParameterInfo(MethodInfo method, short position) {
        this.method = method;
        this.position = position;
    }

    public static MethodParameterInfo create(MethodInfo method, short parameter) {
        return new MethodParameterInfo(method, parameter);
    }

    public final MethodInfo method() {
        return this.method;
    }

    public final short position() {
        return this.position;
    }

    public final String name() {
        return this.method.parameterName(this.position);
    }

    public final Type type() {
        return this.method.parameterType(this.position);
    }

    private boolean targetsThis(AnnotationInstance annotation) {
        return annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER && annotation.target().asMethodParameter().position == this.position;
    }

    private boolean targetsThisOrNested(AnnotationInstance annotation) {
        return this.targetsThis(annotation) || annotation.target().kind() == AnnotationTarget.Kind.TYPE && annotation.target().asType().usage() == TypeTarget.Usage.METHOD_PARAMETER && annotation.target().asType().asMethodParameterType().position() == this.position;
    }

    @Override
    public boolean hasAnnotation(DotName name) {
        return this.annotation(name) != null;
    }

    @Override
    public AnnotationInstance annotation(DotName name) {
        for (AnnotationInstance instance : this.method.methodInternal().annotationArray()) {
            if (!this.targetsThisOrNested(instance) || !instance.name().equals(name)) continue;
            return instance;
        }
        return null;
    }

    public List<AnnotationInstance> annotations(DotName name) {
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance instance : this.method.methodInternal().annotationArray()) {
            if (!this.targetsThisOrNested(instance) || !instance.name().equals(name)) continue;
            instances.add(instance);
        }
        return Collections.unmodifiableList(instances);
    }

    public List<AnnotationInstance> annotationsWithRepeatable(DotName name, IndexView index) {
        if (index == null) {
            throw new IllegalArgumentException("Index must not be null");
        }
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>(this.annotations(name));
        ClassInfo annotationClass = index.getClassByName(name);
        if (annotationClass == null) {
            throw new IllegalArgumentException("Index does not contain the annotation definition: " + name);
        }
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annotationClass);
        }
        AnnotationInstance repeatable = annotationClass.declaredAnnotation(Index.REPEATABLE);
        if (repeatable != null) {
            Type containingType = repeatable.value().asClass();
            for (AnnotationInstance container : this.annotations(containingType.name())) {
                for (AnnotationInstance nestedInstance : container.value().asNestedArray()) {
                    instances.add(AnnotationInstance.create(nestedInstance, container.target()));
                }
            }
        }
        return Collections.unmodifiableList(instances);
    }

    public List<AnnotationInstance> annotations() {
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance instance : this.method.methodInternal().annotationArray()) {
            if (!this.targetsThisOrNested(instance)) continue;
            instances.add(instance);
        }
        return Collections.unmodifiableList(instances);
    }

    @Override
    public boolean hasDeclaredAnnotation(DotName name) {
        return this.declaredAnnotation(name) != null;
    }

    @Override
    public AnnotationInstance declaredAnnotation(DotName name) {
        for (AnnotationInstance instance : this.method.methodInternal().annotationArray()) {
            if (!this.targetsThis(instance) || !instance.name().equals(name)) continue;
            return instance;
        }
        return null;
    }

    public List<AnnotationInstance> declaredAnnotationsWithRepeatable(DotName name, IndexView index) {
        Type containingType;
        AnnotationInstance container;
        ClassInfo annotationClass;
        if (index == null) {
            throw new IllegalArgumentException("Index must not be null");
        }
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        AnnotationInstance declaredInstance = this.declaredAnnotation(name);
        if (declaredInstance != null) {
            instances.add(declaredInstance);
        }
        if ((annotationClass = index.getClassByName(name)) == null) {
            throw new IllegalArgumentException("Index does not contain the annotation definition: " + name);
        }
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annotationClass);
        }
        AnnotationInstance repeatable = annotationClass.declaredAnnotation(Index.REPEATABLE);
        if (repeatable != null && (container = this.declaredAnnotation((containingType = repeatable.value().asClass()).name())) != null) {
            for (AnnotationInstance nestedInstance : container.value().asNestedArray()) {
                instances.add(AnnotationInstance.create(nestedInstance, container.target()));
            }
        }
        return Collections.unmodifiableList(instances);
    }

    public List<AnnotationInstance> declaredAnnotations() {
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance instance : this.method.methodInternal().annotationArray()) {
            if (!this.targetsThis(instance)) continue;
            instances.add(instance);
        }
        return Collections.unmodifiableList(instances);
    }

    public String toString() {
        return this.method + " #" + this.position;
    }

    @Override
    public final ClassInfo asClass() {
        throw new IllegalArgumentException("Not a class");
    }

    @Override
    public final FieldInfo asField() {
        throw new IllegalArgumentException("Not a field");
    }

    @Override
    public final MethodInfo asMethod() {
        throw new IllegalArgumentException("Not a method");
    }

    @Override
    public final MethodParameterInfo asMethodParameter() {
        return this;
    }

    @Override
    public final TypeTarget asType() {
        throw new IllegalArgumentException("Not a type");
    }

    @Override
    public final RecordComponentInfo asRecordComponent() {
        throw new IllegalArgumentException("Not a record component");
    }

    @Override
    public AnnotationTarget.Kind kind() {
        return AnnotationTarget.Kind.METHOD_PARAMETER;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodParameterInfo other = (MethodParameterInfo)o;
        return this.method.equals(other.method) && this.position == other.position;
    }
}

