/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions;

import io.sundr.Function;
import io.sundr.builder.Constants;
import io.sundr.builder.Visitor;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TypeAs implements Function<JavaType, JavaType>
{
    FLUENT_INTERFACE{

        public JavaType apply(JavaType item) {
            BuilderContext ctx = BuilderContextManager.getContext();
            JavaType fluent = (JavaType)SHALLOW_FLUENT.apply(item);
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            JavaType generic = BuilderUtils.getNextGeneric(item, generics);
            JavaType genericFluent = TypeUtils.typeExtends((JavaType)generic, (JavaType)fluent);
            generics.add(genericFluent);
            JavaType superClass = BuilderUtils.isBuildable((AttributeSupport)item.getSuperClass()) ? (JavaType)SHALLOW_FLUENT.apply(item.getSuperClass()) : ctx.getBaseFluentClass().getType();
            HashSet<JavaType> interfaceTypes = new HashSet<JavaType>();
            if (!superClass.getFullyQualifiedName().equals(ctx.getBaseFluentClass().getType().getFullyQualifiedName())) {
                interfaceTypes.add(TypeUtils.typeGenericOf((JavaType)superClass, (JavaType[])new JavaType[]{generic}));
            }
            interfaceTypes.add(TypeUtils.typeGenericOf((JavaType)ctx.getFluentInterface().getType(), (JavaType[])new JavaType[]{generic}));
            return ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withKind(JavaKind.INTERFACE)).withClassName(item.getClassName() + "Fluent")).withPackageName(item.getPackageName())).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).withInterfaces(interfaceTypes)).build();
        }
    }
    ,
    FLUENT_IMPL{

        public JavaType apply(JavaType item) {
            BuilderContext ctx = BuilderContextManager.getContext();
            JavaType fluent = (JavaType)SHALLOW_FLUENT.apply(item);
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            JavaType generic = BuilderUtils.getNextGeneric(item, generics);
            JavaType genericFluent = TypeUtils.typeExtends((JavaType)generic, (JavaType)fluent);
            generics.add(genericFluent);
            JavaType superClass = BuilderUtils.isBuildable((AttributeSupport)item.getSuperClass()) ? TypeUtils.typeGenericOf((JavaType)((JavaType)FLUENT_IMPL.apply(item.getSuperClass())), (JavaType[])new JavaType[]{generic}) : TypeUtils.typeGenericOf((JavaType)ctx.getBaseFluentClass().getType(), (JavaType[])new JavaType[]{generic});
            return ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withKind(JavaKind.CLASS)).withClassName(item.getClassName() + "FluentImpl")).withPackageName(item.getPackageName())).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).withSuperClass(superClass)).withInterfaces(new JavaType[]{(JavaType)SHALLOW_FLUENT.apply(item)})).build();
        }
    }
    ,
    SHALLOW_FLUENT{

        public JavaType apply(JavaType item) {
            ArrayList<Object> generics = new ArrayList<Object>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(REMOVE_SUPERCLASS.apply(generic));
            }
            generics.add(BuilderUtils.getNextGeneric(item, new JavaType[0]));
            return ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withKind(JavaKind.INTERFACE)).withClassName(item.getClassName() + "Fluent")).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build();
        }
    }
    ,
    GENERIC_FLUENT{

        public JavaType apply(JavaType item) {
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            generics.add(Constants.Q);
            return (JavaType)REMOVE_GENERICS_BOUNDS.apply(((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withClassName(item.getClassName() + "Fluent")).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build());
        }
    }
    ,
    BUILDER{

        public JavaType apply(JavaType item) {
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            JavaType builder = (JavaType)SHALLOW_BUILDER.apply(item);
            generics.add(builder);
            JavaType fluent = (JavaType)REMOVE_GENERICS_BOUNDS.apply(TypeUtils.typeGenericOf((JavaType)((JavaType)FLUENT_IMPL.apply(item)), (JavaType[])generics.toArray(new JavaType[generics.size()])));
            generics.remove(builder);
            return ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withKind(JavaKind.CLASS)).withClassName(item.getClassName() + "Builder")).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).withSuperClass(fluent)).withInterfaces(new HashSet<JavaType>(Arrays.asList((JavaType)REMOVE_GENERICS_BOUNDS.apply(TypeUtils.typeGenericOf((JavaType)BuilderContextManager.getContext().getVisitableBuilderInterface().getType(), (JavaType[])new JavaType[]{item, builder})))))).build();
        }
    }
    ,
    EDITABLE{

        public JavaType apply(JavaType item) {
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            return ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withKind(JavaKind.CLASS)).withClassName("Editable" + item.getClassName())).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).withSuperClass((JavaType)REMOVE_GENERICS_BOUNDS.apply(item))).withInterfaces(new HashSet<JavaType>(Arrays.asList((JavaType)REMOVE_GENERICS_BOUNDS.apply(TypeUtils.typeGenericOf((JavaType)BuilderContextManager.getContext().getEditableInterface().getType(), (JavaType[])new JavaType[]{(JavaType)SHALLOW_BUILDER.apply(item)})))))).build();
        }
    }
    ,
    SHALLOW_INLINEABLE{

        public JavaType apply(JavaType item) {
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            return ((JavaTypeBuilder)new JavaTypeBuilder(item).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build();
        }
    }
    ,
    INLINEABLE{

        public JavaType apply(JavaType item) {
            JavaType fluent = (JavaType)FLUENT_IMPL.apply(item);
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            return ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).withSuperClass(TypeUtils.typeGenericOf((JavaType)fluent, (JavaType[])new JavaType[]{(JavaType)SHALLOW_INLINEABLE.apply(item)}))).build();
        }
    }
    ,
    SHALLOW_BUILDER{

        public JavaType apply(JavaType item) {
            ArrayList<JavaType> generics = new ArrayList<JavaType>();
            for (JavaType generic : item.getGenericTypes()) {
                generics.add(generic);
            }
            return (JavaType)REMOVE_GENERICS_BOUNDS.apply(((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(item).withClassName(item.getClassName() + "Builder")).withGenericTypes(generics.toArray(new JavaType[generics.size()]))).build());
        }
    }
    ,
    VISITABLE_BUILDER{

        public JavaType apply(JavaType item) {
            JavaType baseType = (JavaType)TypeAs.combine(UNWRAP_COLLECTION_OF, UNWRAP_ARRAY_OF).apply((Object)item);
            baseType = ((JavaTypeBuilder)new JavaTypeBuilder(baseType).withGenericTypes(new JavaType[0])).build();
            return ((JavaTypeBuilder)new JavaTypeBuilder(BuilderContextManager.getContext().getVisitableBuilderInterface().getType()).withGenericTypes(new JavaType[]{baseType, Constants.Q})).build();
        }
    }
    ,
    LIST_OF{

        public JavaType apply(JavaType item) {
            return ((JavaTypeBuilder)((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(Constants.LIST).withCollection(true)).withGenericTypes(new JavaType[]{item})).withDefaultImplementation(Constants.ARRAY_LIST)).build();
        }
    }
    ,
    ARRAY_AS_LIST{

        public JavaType apply(JavaType item) {
            return (JavaType)LIST_OF.apply(UNWRAP_ARRAY_OF.apply(item));
        }
    }
    ,
    ARRAY_LIST_OF{

        public JavaType apply(JavaType item) {
            return TypeUtils.typeGenericOf((JavaType)Constants.ARRAY_LIST, (JavaType[])new JavaType[]{item});
        }
    }
    ,
    UNWRAP_COLLECTION_OF{

        public JavaType apply(JavaType type) {
            if (type.isCollection()) {
                return type.getGenericTypes()[0];
            }
            return type;
        }
    }
    ,
    UNWRAP_ARRAY_OF{

        public JavaType apply(JavaType type) {
            return ((JavaTypeBuilder)new JavaTypeBuilder(type).withArray(false)).build();
        }
    }
    ,
    REMOVE_GENERICS{

        public JavaType apply(JavaType type) {
            return ((JavaTypeBuilder)new JavaTypeBuilder(type).withGenericTypes(new JavaType[0])).build();
        }
    }
    ,
    REMOVE_GENERICS_BOUNDS{

        public JavaType apply(JavaType type) {
            return ((JavaTypeBuilder)new JavaTypeBuilder(type).accept((Visitor)new Visitor<JavaTypeBuilder>(){

                public void visit(JavaTypeBuilder builder) {
                    if (builder.getGenericTypes().length > 0) {
                        ArrayList<Object> generics = new ArrayList<Object>();
                        for (JavaType generic : builder.getGenericTypes()) {
                            generics.add(REMOVE_SUPERCLASS.apply(generic));
                        }
                        builder.withGenericTypes(generics.toArray(new JavaType[generics.size()]));
                    }
                }
            })).build();
        }
    }
    ,
    REMOVE_SUPERCLASS{

        public JavaType apply(JavaType type) {
            return ((JavaTypeBuilder)new JavaTypeBuilder(type).withSuperClass(null)).build();
        }
    }
    ,
    BOXED_OF{

        public JavaType apply(JavaType type) {
            int index = 0;
            for (JavaType primitive : Constants.PRIMITIVE_TYPES) {
                if (primitive.equals((Object)type)) {
                    return Constants.BOXED_PRIMITIVE_TYPES[index];
                }
                ++index;
            }
            return type;
        }
    };


    public static Function<JavaType, JavaType> combine(final Function<JavaType, JavaType> ... functions) {
        return new Function<JavaType, JavaType>(){

            public JavaType apply(JavaType item) {
                JavaType result = item;
                for (Function f : functions) {
                    result = (JavaType)f.apply((Object)result);
                }
                return result;
            }
        };
    }
}

