/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.CoordinateConverter;
import java.util.List;

@DataObject(generateConverter=true)
public class Coordinate {
    private String node;
    private float adj;
    private float err;
    private float height;
    private List<Float> vec;

    public Coordinate() {
    }

    public Coordinate(Coordinate coordinate) {
        this.node = coordinate.node;
        this.adj = coordinate.adj;
        this.err = coordinate.err;
        this.height = coordinate.height;
        this.vec = coordinate.vec;
    }

    public Coordinate(JsonObject coordinate) {
        CoordinateConverter.fromJson(coordinate, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        CoordinateConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public String getNode() {
        return this.node;
    }

    public float getAdj() {
        return this.adj;
    }

    public float getErr() {
        return this.err;
    }

    public float getHeight() {
        return this.height;
    }

    public List<Float> getVec() {
        return this.vec;
    }

    public Coordinate setNode(String node) {
        this.node = node;
        return this;
    }

    public Coordinate setAdj(float adj) {
        this.adj = adj;
        return this;
    }

    public Coordinate setErr(float err) {
        this.err = err;
        return this;
    }

    public Coordinate setHeight(float height) {
        this.height = height;
        return this;
    }

    public Coordinate setVec(List<Float> vec) {
        this.vec = vec;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        if (Float.compare(that.adj, this.adj) != 0) {
            return false;
        }
        if (Float.compare(that.err, this.err) != 0) {
            return false;
        }
        if (Float.compare(that.height, this.height) != 0) {
            return false;
        }
        if (this.node != null ? !this.node.equals(that.node) : that.node != null) {
            return false;
        }
        return this.vec != null ? this.vec.equals(that.vec) : that.vec == null;
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + (this.adj != 0.0f ? Float.floatToIntBits(this.adj) : 0);
        result = 31 * result + (this.err != 0.0f ? Float.floatToIntBits(this.err) : 0);
        result = 31 * result + (this.height != 0.0f ? Float.floatToIntBits(this.height) : 0);
        result = 31 * result + (this.vec != null ? this.vec.hashCode() : 0);
        return result;
    }
}

