/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Coordinate;
import io.vertx.ext.consul.DcCoordinates;
import java.util.ArrayList;

public class DcCoordinatesConverter {
    public static void fromJson(JsonObject json, DcCoordinates obj) {
        if (json.getValue("datacenter") instanceof String) {
            obj.setDatacenter((String)json.getValue("datacenter"));
        }
        if (json.getValue("servers") instanceof JsonArray) {
            ArrayList<Coordinate> list = new ArrayList<Coordinate>();
            json.getJsonArray("servers").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add(new Coordinate((JsonObject)item));
                }
            });
            obj.setServers(list);
        }
    }

    public static void toJson(DcCoordinates obj, JsonObject json) {
        if (obj.getDatacenter() != null) {
            json.put("datacenter", obj.getDatacenter());
        }
        if (obj.getServers() != null) {
            JsonArray array = new JsonArray();
            obj.getServers().forEach(item -> array.add(item.toJson()));
            json.put("servers", array);
        }
    }
}

