/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.NodeListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@DataObject(generateConverter=true)
public class NodeList {
    private long index;
    private List<Node> list;

    public NodeList() {
    }

    public NodeList(NodeList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public NodeList(JsonObject json) {
        NodeListConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        NodeListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getIndex() {
        return this.index;
    }

    public NodeList setIndex(long index) {
        this.index = index;
        return this;
    }

    public List<Node> getList() {
        return this.list;
    }

    public NodeList setList(List<Node> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeList nodeList = (NodeList)o;
        if (this.index != nodeList.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(nodeList.sorted()) : nodeList.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<Node> sorted() {
        ArrayList<Node> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<Node>(this.list);
            sorted.sort(Comparator.comparing(Node::getName));
        }
        return sorted;
    }
}

