/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.SessionConverter;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class Session {
    private long lockDelay;
    private String node;
    private List<String> checks;
    private long createIndex;
    private long index;
    private String id;

    public Session() {
    }

    public Session(Session other) {
        this.lockDelay = other.lockDelay;
        this.node = other.node;
        this.checks = other.checks;
        this.createIndex = other.createIndex;
        this.index = other.index;
        this.id = other.id;
    }

    public Session(JsonObject session) {
        SessionConverter.fromJson(session, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        SessionConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getLockDelay() {
        return this.lockDelay;
    }

    public String getNode() {
        return this.node;
    }

    public List<String> getChecks() {
        return this.checks;
    }

    public String getId() {
        return this.id;
    }

    public long getCreateIndex() {
        return this.createIndex;
    }

    public long getIndex() {
        return this.index;
    }

    public Session setLockDelay(long lockDelay) {
        this.lockDelay = lockDelay;
        return this;
    }

    public Session setNode(String node) {
        this.node = node;
        return this;
    }

    public Session setChecks(List<String> checks) {
        this.checks = checks;
        return this;
    }

    public Session setCreateIndex(long createIndex) {
        this.createIndex = createIndex;
        return this;
    }

    public Session setId(String id) {
        this.id = id;
        return this;
    }

    public Session setIndex(long index) {
        this.index = index;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (this.lockDelay != session.lockDelay) {
            return false;
        }
        if (this.createIndex != session.createIndex) {
            return false;
        }
        if (this.index != session.index) {
            return false;
        }
        if (this.node != null ? !this.node.equals(session.node) : session.node != null) {
            return false;
        }
        if (this.checks != null ? !this.sorted().equals(session.sorted()) : session.checks != null) {
            return false;
        }
        return this.id != null ? this.id.equals(session.id) : session.id == null;
    }

    public int hashCode() {
        int result = (int)(this.lockDelay ^ this.lockDelay >>> 32);
        result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
        result = 31 * result + (this.checks != null ? this.sorted().hashCode() : 0);
        result = 31 * result + (int)(this.createIndex ^ this.createIndex >>> 32);
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    private List<String> sorted() {
        ArrayList<String> sorted = null;
        if (this.checks != null) {
            sorted = new ArrayList<String>(this.checks);
            sorted.sort(String::compareTo);
        }
        return sorted;
    }
}

