/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.impl.MySQLPoolOptions;
import io.vertx.mysqlclient.spi.MySQLDriver;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface MySQLPool
extends Pool {
    public static MySQLPool pool(String connectionUri) {
        return MySQLPool.pool(connectionUri, new PoolOptions());
    }

    public static MySQLPool pool(String connectionUri, PoolOptions options) {
        return MySQLPool.pool(MySQLConnectOptions.fromUri(connectionUri), options);
    }

    public static MySQLPool pool(Vertx vertx, String connectionUri) {
        return MySQLPool.pool(vertx, MySQLConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static MySQLPool pool(Vertx vertx, String connectionUri, PoolOptions options) {
        return MySQLPool.pool(vertx, MySQLConnectOptions.fromUri(connectionUri), options);
    }

    public static MySQLPool pool(MySQLConnectOptions database, PoolOptions options) {
        return MySQLPool.pool(null, database, options);
    }

    public static MySQLPool pool(Vertx vertx, MySQLConnectOptions database, PoolOptions options) {
        return MySQLPool.pool(vertx, Collections.singletonList(database), options);
    }

    public static MySQLPool pool(List<MySQLConnectOptions> databases, PoolOptions options) {
        return MySQLPool.pool(null, databases, options);
    }

    public static MySQLPool pool(Vertx vertx, List<MySQLConnectOptions> databases, PoolOptions options) {
        return (MySQLPool)MySQLDriver.INSTANCE.createPool(vertx, databases, options);
    }

    public static SqlClient client(String connectionUri) {
        return MySQLPool.client(connectionUri, new PoolOptions());
    }

    public static SqlClient client(String connectionUri, PoolOptions poolOptions) {
        return MySQLPool.client(MySQLConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static SqlClient client(Vertx vertx, String connectionUri) {
        return MySQLPool.client(vertx, MySQLConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static SqlClient client(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return MySQLPool.client(vertx, MySQLConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static SqlClient client(MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        return MySQLPool.client(null, Collections.singletonList(connectOptions), poolOptions);
    }

    public static SqlClient client(Vertx vertx, MySQLConnectOptions connectOptions, PoolOptions poolOptions) {
        return MySQLPool.client(vertx, Collections.singletonList(connectOptions), poolOptions);
    }

    public static SqlClient client(Vertx vertx, List<MySQLConnectOptions> mySQLConnectOptions, PoolOptions options) {
        return MySQLDriver.INSTANCE.createPool(vertx, mySQLConnectOptions, new MySQLPoolOptions(options).setPipelined(true));
    }

    public static SqlClient client(List<MySQLConnectOptions> databases, PoolOptions options) {
        return MySQLPool.client(null, databases, options);
    }

    public MySQLPool connectHandler(Handler<SqlConnection> var1);

    @Fluent
    public MySQLPool connectionProvider(Function<Context, Future<SqlConnection>> var1);
}

