/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

public class HexSequence {
    private long i;

    public HexSequence() {
        this.i = 0L;
    }

    public HexSequence(long startValue) {
        this.i = startValue;
    }

    private static byte toHex(long c) {
        if (c < 10L) {
            return (byte)(48L + c);
        }
        return (byte)(65L + c - 10L);
    }

    public byte[] next() {
        int len = 3 + (64 - Long.numberOfLeadingZeros(this.i) + 3) / 4 + 1;
        len = Math.max(8, len);
        byte[] hex = new byte[len];
        int pos = len - 1;
        hex[pos--] = 0;
        for (long n = this.i; n != 0L; n >>>= 4) {
            hex[pos--] = HexSequence.toHex(n & 0xFL);
        }
        while (pos >= 0) {
            hex[pos--] = 48;
        }
        ++this.i;
        return hex;
    }
}

