/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.gitignore;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.codeowners.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.gitignore.parser.GitIgnoreBaseVisitor;
import nl.basjes.gitignore.parser.GitIgnoreLexer;
import nl.basjes.gitignore.parser.GitIgnoreParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitIgnore
extends GitIgnoreBaseVisitor<Void> {
    private static final String GITIGNORE_PATH_SEPARATOR = "/";
    private static final Logger LOG = LoggerFactory.getLogger(GitIgnore.class);
    private final String projectRelativeBaseDir;
    private final List<IgnoreRule> ignoreRules = new ArrayList<IgnoreRule>();
    private boolean verbose = false;

    public GitIgnore(File file) throws IOException {
        this("", file);
    }

    public GitIgnore(String projectRelativeBaseDir, File file) throws IOException {
        this(projectRelativeBaseDir, FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
    }

    public GitIgnore(String gitIgnoreContent) {
        this("", gitIgnoreContent);
    }

    public GitIgnore(String projectRelativeBaseDir, String gitIgnoreContent) {
        this.projectRelativeBaseDir = GitIgnore.standardizeFilename(projectRelativeBaseDir + GITIGNORE_PATH_SEPARATOR);
        CodePointCharStream input = CharStreams.fromString(gitIgnoreContent);
        GitIgnoreLexer lexer = new GitIgnoreLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        GitIgnoreParser parser = new GitIgnoreParser(tokens);
        GitIgnoreParser.GitignoreContext gitignore = parser.gitignore();
        this.visit(gitignore);
    }

    public Boolean isIgnoredFile(String filename) {
        Boolean mustBeIgnored;
        block9: {
            String matchFileName;
            block8: {
                if (this.verbose) {
                    LOG.info("# vvvvvvvvvvvvvvvvvvvvvvvvvvv");
                    LOG.info("Checking: {}", (Object)filename);
                }
                matchFileName = GitIgnore.standardizeFilename(filename);
                if (this.verbose) {
                    LOG.info("Matching: {}", (Object)matchFileName);
                }
                mustBeIgnored = null;
                if (matchFileName.startsWith(this.projectRelativeBaseDir)) break block8;
                if (!this.verbose) break block9;
                LOG.info("# Not in my baseDir: {}", (Object)this.projectRelativeBaseDir);
                break block9;
            }
            for (IgnoreRule ignoreRule : this.ignoreRules) {
                Boolean ruleVerdict = ignoreRule.isIgnoredFile(matchFileName);
                if (ruleVerdict == null) continue;
                mustBeIgnored = ruleVerdict;
                if (!ruleVerdict.booleanValue() || !ignoreRule.isDirectoryMatch()) continue;
                break;
            }
        }
        if (this.verbose) {
            if (mustBeIgnored == null) {
                LOG.info("Conclusion: Not matched: Not ignored");
            } else if (Boolean.TRUE.equals(mustBeIgnored)) {
                LOG.info("Conclusion: Must be ignored");
            } else {
                LOG.info("Conclusion: Must NOT be ignored");
            }
        }
        return mustBeIgnored;
    }

    static String standardizeFilename(String filename) {
        String unixifiedName = FilenameUtils.separatorsToUnix((String)filename);
        if (!unixifiedName.matches("^[a-zA-Z]:/.*")) {
            unixifiedName = GITIGNORE_PATH_SEPARATOR + unixifiedName;
        }
        return unixifiedName.replaceAll("/+", GITIGNORE_PATH_SEPARATOR);
    }

    public boolean ignoreFile(String filename) {
        return Boolean.TRUE.equals(this.isIgnoredFile(filename));
    }

    public boolean keepFile(String filename) {
        return !this.ignoreFile(filename);
    }

    @Override
    public Void visitIgnoreRule(GitIgnoreParser.IgnoreRuleContext ctx) {
        String filePattern = ctx.fileExpression.getText();
        this.ignoreRules.add(new IgnoreRule(this.projectRelativeBaseDir, ctx.not != null, filePattern));
        return null;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.ignoreRules.forEach(rule -> rule.setVerbose(verbose));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("# GitIgnore file:\n");
        for (IgnoreRule ignoreRule : this.ignoreRules) {
            result.append(ignoreRule).append('\n');
        }
        return result.toString();
    }

    public String getProjectRelativeBaseDir() {
        return this.projectRelativeBaseDir;
    }

    List<IgnoreRule> getIgnoreRules() {
        return new ArrayList<IgnoreRule>(this.ignoreRules);
    }

    static class IgnoreRule {
        private final String projectRelativeBaseDir;
        private final boolean negate;
        private final String fileExpression;
        private final boolean directoryMatch;
        private final Pattern filePattern;
        private boolean verbose = false;

        public IgnoreRule(String projectRelativeBaseDir, boolean negate, String fileExpression) {
            String baseDirRegex;
            if (projectRelativeBaseDir == null || GitIgnore.GITIGNORE_PATH_SEPARATOR.equals(projectRelativeBaseDir) || projectRelativeBaseDir.trim().isEmpty()) {
                this.projectRelativeBaseDir = GitIgnore.GITIGNORE_PATH_SEPARATOR;
                baseDirRegex = "^/?";
            } else {
                this.projectRelativeBaseDir = (GitIgnore.GITIGNORE_PATH_SEPARATOR + projectRelativeBaseDir.trim() + GitIgnore.GITIGNORE_PATH_SEPARATOR).replaceAll("/+", GitIgnore.GITIGNORE_PATH_SEPARATOR);
                baseDirRegex = "^/?\\Q" + this.projectRelativeBaseDir.substring(1) + "\\E";
            }
            this.negate = negate;
            this.fileExpression = fileExpression;
            this.directoryMatch = !negate && fileExpression.endsWith(GitIgnore.GITIGNORE_PATH_SEPARATOR);
            String fileRegex = fileExpression.trim().replaceAll("^!", "").replace("[!", "[^");
            if (fileExpression.contains(GitIgnore.GITIGNORE_PATH_SEPARATOR) && !fileExpression.endsWith(GitIgnore.GITIGNORE_PATH_SEPARATOR)) {
                if (fileRegex.startsWith(GitIgnore.GITIGNORE_PATH_SEPARATOR)) {
                    fileRegex = fileRegex.substring(1);
                }
            } else {
                fileRegex = fileRegex.replaceAll("^([^/*.])", "**/$1");
            }
            fileRegex = fileRegex.replace("\\ ", " ").replaceAll("([^/*])$", "$1(/|\\$)").replace(".", "\\.").replace("\\.*", "\\..*").replace("?", ".").replaceAll("^\\*\\*/", "(.*/)?").replace("/**", "(/.*)?").replace("/*/", "/[^/]+/").replace("/*/", "/[^/]+/").replace("**", ".*").replaceAll("^\\*", ".*").replaceAll("^/", "^/").replaceAll("/\\*([^/]*)$", "/[^/]*$1\\$").replace("/*", "/.*").replaceAll("([^.\\]])\\*", "$1.*").replaceAll("/+", GitIgnore.GITIGNORE_PATH_SEPARATOR).replace("/\\E/", "/\\E");
            this.filePattern = Pattern.compile(baseDirRegex + fileRegex);
        }

        public Boolean isIgnoredFile(String filename) {
            if (!this.filePattern.matcher(filename).find()) {
                if (this.verbose) {
                    LOG.info("NO MATCH     |{}| ~ |{}| --> |{}|", new Object[]{this.fileExpression, this.filePattern, filename});
                }
                return null;
            }
            if (this.negate) {
                if (this.verbose) {
                    LOG.info("MATCH NEGATE |{}| ~ |{}| --> |{}|", new Object[]{this.fileExpression, this.filePattern, filename});
                }
                return Boolean.FALSE;
            }
            if (this.verbose) {
                LOG.info("MATCH IGNORE |{}| ~ |{}| --> |{}|", new Object[]{this.fileExpression, this.filePattern, filename});
            }
            return Boolean.TRUE;
        }

        public boolean isDirectoryMatch() {
            return this.directoryMatch;
        }

        public String getIgnoreBasedir() {
            return this.projectRelativeBaseDir;
        }

        public String getIgnoreExpression() {
            return (this.negate ? "!" : "") + this.fileExpression;
        }

        public Pattern getIgnorePattern() {
            return this.filePattern;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public String toString() {
            return String.format("%-20s     # Used Regex: %s", (this.negate ? "!" : "") + this.fileExpression, this.filePattern);
        }
    }
}

