/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.drivermanager;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.arrow.adbc.core.AdbcDatabase;
import org.apache.arrow.adbc.core.AdbcDriver;
import org.apache.arrow.adbc.core.AdbcException;
import org.apache.arrow.adbc.core.AdbcStatusCode;
import org.apache.arrow.adbc.drivermanager.AdbcDriverFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AdbcDriverManager {
    private static final AdbcDriverManager INSTANCE = new AdbcDriverManager();
    private final ConcurrentMap<String, Function<BufferAllocator, AdbcDriver>> driverFactoryFunctions = new ConcurrentHashMap<String, Function<BufferAllocator, AdbcDriver>>();

    private AdbcDriverManager() {
        ServiceLoader<AdbcDriverFactory> serviceLoader = ServiceLoader.load(AdbcDriverFactory.class);
        for (AdbcDriverFactory driverFactory : serviceLoader) {
            @Nullable String className = driverFactory.getClass().getCanonicalName();
            if (className == null) {
                throw new RuntimeException("Class has no canonical name");
            }
            this.driverFactoryFunctions.putIfAbsent(className, driverFactory::getDriver);
        }
    }

    public AdbcDatabase connect(String driverFactoryName, BufferAllocator allocator, Map<String, Object> parameters) throws AdbcException {
        Function<BufferAllocator, AdbcDriver> driverFactoryFunction = this.lookupDriver(driverFactoryName);
        if (driverFactoryFunction == null) {
            throw new AdbcException("AdbcDriverFactory not found for '" + driverFactoryName + "'", null, AdbcStatusCode.NOT_FOUND, null, 0);
        }
        return driverFactoryFunction.apply(allocator).open(parameters);
    }

    @Nullable Function<BufferAllocator, AdbcDriver> lookupDriver(String driverFactoryName) {
        return (Function)this.driverFactoryFunctions.get(driverFactoryName);
    }

    public void registerDriver(String driverFactoryName, Function<BufferAllocator, AdbcDriver> driverFactory) {
        if (this.driverFactoryFunctions.putIfAbsent(driverFactoryName, driverFactory) != null) {
            throw new IllegalStateException("[DriverManager] Driver factory already registered for '" + driverFactoryName + "'");
        }
    }

    public static AdbcDriverManager getInstance() {
        return INSTANCE;
    }
}

