/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.sql;

import java.util.function.Function;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlQuirks {
    public static final Function<ArrowType, @Nullable String> DEFAULT_ARROW_TYPE_TO_SQL_TYPE_NAME_MAPPING = arrowType -> {
        switch (arrowType.getTypeID()) {
            case Null: 
            case Struct: 
            case List: 
            case LargeList: 
            case FixedSizeList: 
            case Union: 
            case Map: {
                return null;
            }
            case Int: {
                return "INT";
            }
            case FloatingPoint: {
                return null;
            }
            case Utf8: {
                return "CLOB";
            }
        }
        return null;
    };
    Function<ArrowType, @Nullable String> arrowToSqlTypeNameMapping = DEFAULT_ARROW_TYPE_TO_SQL_TYPE_NAME_MAPPING;

    public Function<ArrowType, @Nullable String> getArrowToSqlTypeNameMapping() {
        return this.arrowToSqlTypeNameMapping;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable Function<ArrowType, @Nullable String> arrowToSqlTypeNameMapping;

        public Builder arrowToSqlTypeNameMapping(@Nullable Function<ArrowType, @Nullable String> mapper) {
            this.arrowToSqlTypeNameMapping = mapper;
            return this;
        }

        public SqlQuirks build() {
            SqlQuirks quirks = new SqlQuirks();
            if (this.arrowToSqlTypeNameMapping != null) {
                quirks.arrowToSqlTypeNameMapping = this.arrowToSqlTypeNameMapping;
            }
            return quirks;
        }
    }
}

